package com.finconsgroup.itserr.marketplace.search.dm.enums;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import lombok.Getter;
import org.springframework.core.convert.converter.Converter;
import org.springframework.lang.NonNull;
import org.springframework.lang.Nullable;
import org.springframework.stereotype.Component;

@Getter
public enum Category {

    INSTITUTIONAL_PAGE("InstitutionalPage"),
    EVENT("Event"),
    NEWS("News"),
    PEOPLE("People"),
    CATALOG("Catalog"),
    DISCUSSION("Discussion");

    private final String id;

    Category(String id) {
        this.id = id;
    }

    @JsonValue
    public String getId() {
        return id;
    }

    /**
     * It maps the name to a {@link Category} object
     *
     * @param id the id to map to category
     * @return {@link Category} instance if found
     * @throws IllegalArgumentException if no matching category instance found
     */
    @JsonCreator
    public static Category ofId(String id) {
        for (Category category : Category.values()) {
            if (category.id.equalsIgnoreCase(id)) {
                return category;
            }
        }

        throw new IllegalArgumentException("Unsupported category : " + id);
    }

    @Component
    public static class CategoryConverter implements Converter<String, Category> {
        @Override
        public @Nullable Category convert(@NonNull String source) {
            return Category.ofId(source);
        }
    }
}
