package com.finconsgroup.itserr.marketplace.search.dm.dto;

import io.swagger.v3.oas.annotations.media.Schema;
import lombok.Builder;
import lombok.Data;

/**
 * It represents the payload to create/update Program Conductor search field.
 */
@Builder
@Schema(
    title = "Create/Update Program Conductor Dto",
    description = "Represents the payload to create/update program conductor field"
)
@Data
public class ProgramConductorDto {

    @Schema(
        description = "First Name",
        example = "John")
    private String firstName;

    @Schema(
        description = "Last Name",
        example = "Doe")
    private String lastName;

    @Schema(
        description = "Email",
        example = "john.doe@example.com")
    private String email;

    @Schema(
        description = "orcid",
        example = "00000-00000-00000-00000")
    private String orcid;
}
