/*
 * Decompiled with CFR 0.152.
 */
package com.finconsgroup.itserr.marketplace.search.dm.dto;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.finconsgroup.itserr.marketplace.core.web.dto.PutIdParameterBody;
import com.finconsgroup.itserr.marketplace.search.dm.dto.ImageMinimalDto;
import com.finconsgroup.itserr.marketplace.search.dm.dto.InputNewsDto;
import com.finconsgroup.itserr.marketplace.search.dm.dto.InstitutionalPageMinimalDto;
import com.finconsgroup.itserr.marketplace.search.dm.dto.RegisteredAuthorDto;
import io.swagger.v3.oas.annotations.Hidden;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.validation.constraints.NotBlank;
import java.time.Instant;
import java.util.List;
import lombok.Generated;

@Schema(name="InputNewsDto", title="Create/Update News search document DTO", description="Represents the payload to create/update an News search document")
public class InputNewsDto
implements PutIdParameterBody {
    @Schema(description="Unique identifier of the news", example="550e8400-e29b-41d4-a716-446655440000")
    @NotBlank
    private String id;
    @Schema(description="The title of the news", example="Annual Tech Conference 2025")
    private String title;
    @Schema(description="The creator of the News")
    private RegisteredAuthorDto creator;
    @Schema(description="The type of news", example="Technology")
    private String newsType;
    @Schema(description="The content of the news", example="Join us for the biggest tech conference of the year...")
    private String content;
    @Schema(description="List of tags associated with the news", example="[\"technology\", \"sports\"]")
    private List<String> tags;
    @Schema(description="List of institutional pages")
    private List<InstitutionalPageMinimalDto> institutionalPages;
    @Schema(description="The image for the news")
    private ImageMinimalDto image;
    @Schema(description="Authors registered and unregistered of the News")
    private List<RegisteredAuthorDto> authors;
    @Schema(description="The creation time of the table record", example="2025-06-20T15:29:06.254836Z")
    private Instant creationTime;
    @Schema(description="The last update time of the table record", example="2025-06-20T15:29:06.254836Z")
    private Instant updateTime;

    @Schema(hidden=true)
    @JsonIgnore
    @Hidden
    public String getPutId() {
        return this.id;
    }

    @Generated
    InputNewsDto(String id, String title, RegisteredAuthorDto creator, String newsType, String content, List<String> tags, List<InstitutionalPageMinimalDto> institutionalPages, ImageMinimalDto image, List<RegisteredAuthorDto> authors, Instant creationTime, Instant updateTime) {
        this.id = id;
        this.title = title;
        this.creator = creator;
        this.newsType = newsType;
        this.content = content;
        this.tags = tags;
        this.institutionalPages = institutionalPages;
        this.image = image;
        this.authors = authors;
        this.creationTime = creationTime;
        this.updateTime = updateTime;
    }

    @Generated
    public static InputNewsDtoBuilder builder() {
        return new InputNewsDtoBuilder();
    }

    @Generated
    public String getId() {
        return this.id;
    }

    @Generated
    public String getTitle() {
        return this.title;
    }

    @Generated
    public RegisteredAuthorDto getCreator() {
        return this.creator;
    }

    @Generated
    public String getNewsType() {
        return this.newsType;
    }

    @Generated
    public String getContent() {
        return this.content;
    }

    @Generated
    public List<String> getTags() {
        return this.tags;
    }

    @Generated
    public List<InstitutionalPageMinimalDto> getInstitutionalPages() {
        return this.institutionalPages;
    }

    @Generated
    public ImageMinimalDto getImage() {
        return this.image;
    }

    @Generated
    public List<RegisteredAuthorDto> getAuthors() {
        return this.authors;
    }

    @Generated
    public Instant getCreationTime() {
        return this.creationTime;
    }

    @Generated
    public Instant getUpdateTime() {
        return this.updateTime;
    }

    @Generated
    public void setId(String id) {
        this.id = id;
    }

    @Generated
    public void setTitle(String title) {
        this.title = title;
    }

    @Generated
    public void setCreator(RegisteredAuthorDto creator) {
        this.creator = creator;
    }

    @Generated
    public void setNewsType(String newsType) {
        this.newsType = newsType;
    }

    @Generated
    public void setContent(String content) {
        this.content = content;
    }

    @Generated
    public void setTags(List<String> tags) {
        this.tags = tags;
    }

    @Generated
    public void setInstitutionalPages(List<InstitutionalPageMinimalDto> institutionalPages) {
        this.institutionalPages = institutionalPages;
    }

    @Generated
    public void setImage(ImageMinimalDto image) {
        this.image = image;
    }

    @Generated
    public void setAuthors(List<RegisteredAuthorDto> authors) {
        this.authors = authors;
    }

    @Generated
    public void setCreationTime(Instant creationTime) {
        this.creationTime = creationTime;
    }

    @Generated
    public void setUpdateTime(Instant updateTime) {
        this.updateTime = updateTime;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof InputNewsDto)) {
            return false;
        }
        InputNewsDto other = (InputNewsDto)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        String this$id = this.getId();
        String other$id = other.getId();
        if (this$id == null ? other$id != null : !this$id.equals(other$id)) {
            return false;
        }
        String this$title = this.getTitle();
        String other$title = other.getTitle();
        if (this$title == null ? other$title != null : !this$title.equals(other$title)) {
            return false;
        }
        RegisteredAuthorDto this$creator = this.getCreator();
        RegisteredAuthorDto other$creator = other.getCreator();
        if (this$creator == null ? other$creator != null : !this$creator.equals(other$creator)) {
            return false;
        }
        String this$newsType = this.getNewsType();
        String other$newsType = other.getNewsType();
        if (this$newsType == null ? other$newsType != null : !this$newsType.equals(other$newsType)) {
            return false;
        }
        String this$content = this.getContent();
        String other$content = other.getContent();
        if (this$content == null ? other$content != null : !this$content.equals(other$content)) {
            return false;
        }
        List this$tags = this.getTags();
        List other$tags = other.getTags();
        if (this$tags == null ? other$tags != null : !((Object)this$tags).equals(other$tags)) {
            return false;
        }
        List this$institutionalPages = this.getInstitutionalPages();
        List other$institutionalPages = other.getInstitutionalPages();
        if (this$institutionalPages == null ? other$institutionalPages != null : !((Object)this$institutionalPages).equals(other$institutionalPages)) {
            return false;
        }
        ImageMinimalDto this$image = this.getImage();
        ImageMinimalDto other$image = other.getImage();
        if (this$image == null ? other$image != null : !this$image.equals(other$image)) {
            return false;
        }
        List this$authors = this.getAuthors();
        List other$authors = other.getAuthors();
        if (this$authors == null ? other$authors != null : !((Object)this$authors).equals(other$authors)) {
            return false;
        }
        Instant this$creationTime = this.getCreationTime();
        Instant other$creationTime = other.getCreationTime();
        if (this$creationTime == null ? other$creationTime != null : !((Object)this$creationTime).equals(other$creationTime)) {
            return false;
        }
        Instant this$updateTime = this.getUpdateTime();
        Instant other$updateTime = other.getUpdateTime();
        return !(this$updateTime == null ? other$updateTime != null : !((Object)this$updateTime).equals(other$updateTime));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof InputNewsDto;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $id = this.getId();
        result = result * 59 + ($id == null ? 43 : $id.hashCode());
        String $title = this.getTitle();
        result = result * 59 + ($title == null ? 43 : $title.hashCode());
        RegisteredAuthorDto $creator = this.getCreator();
        result = result * 59 + ($creator == null ? 43 : $creator.hashCode());
        String $newsType = this.getNewsType();
        result = result * 59 + ($newsType == null ? 43 : $newsType.hashCode());
        String $content = this.getContent();
        result = result * 59 + ($content == null ? 43 : $content.hashCode());
        List $tags = this.getTags();
        result = result * 59 + ($tags == null ? 43 : ((Object)$tags).hashCode());
        List $institutionalPages = this.getInstitutionalPages();
        result = result * 59 + ($institutionalPages == null ? 43 : ((Object)$institutionalPages).hashCode());
        ImageMinimalDto $image = this.getImage();
        result = result * 59 + ($image == null ? 43 : $image.hashCode());
        List $authors = this.getAuthors();
        result = result * 59 + ($authors == null ? 43 : ((Object)$authors).hashCode());
        Instant $creationTime = this.getCreationTime();
        result = result * 59 + ($creationTime == null ? 43 : ((Object)$creationTime).hashCode());
        Instant $updateTime = this.getUpdateTime();
        result = result * 59 + ($updateTime == null ? 43 : ((Object)$updateTime).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "InputNewsDto(id=" + this.getId() + ", title=" + this.getTitle() + ", creator=" + String.valueOf(this.getCreator()) + ", newsType=" + this.getNewsType() + ", content=" + this.getContent() + ", tags=" + String.valueOf(this.getTags()) + ", institutionalPages=" + String.valueOf(this.getInstitutionalPages()) + ", image=" + String.valueOf(this.getImage()) + ", authors=" + String.valueOf(this.getAuthors()) + ", creationTime=" + String.valueOf(this.getCreationTime()) + ", updateTime=" + String.valueOf(this.getUpdateTime()) + ")";
    }
}

