package com.finconsgroup.itserr.marketplace.search.dm.mapper;

import com.finconsgroup.itserr.marketplace.search.dm.dto.EventConductorDto;
import com.finconsgroup.itserr.marketplace.search.dm.dto.EventProgramDto;
import com.finconsgroup.itserr.marketplace.search.dm.dto.EventScheduleDto;
import com.finconsgroup.itserr.marketplace.search.dm.dto.EventSubscribedParticipantDto;
import com.finconsgroup.itserr.marketplace.search.dm.dto.ImageMinimalDto;
import com.finconsgroup.itserr.marketplace.search.dm.dto.InputEventDto;
import com.finconsgroup.itserr.marketplace.search.dm.dto.InstitutionalPageMinimalDto;
import com.finconsgroup.itserr.marketplace.search.dm.dto.LocationDto;
import com.finconsgroup.itserr.marketplace.search.dm.dto.OutputEventDto;
import com.finconsgroup.itserr.marketplace.search.dm.dto.OutputEventLocalSearchDto;
import com.finconsgroup.itserr.marketplace.search.dm.dto.OutputGlobalSearchAutoCompleteDataDto;
import com.finconsgroup.itserr.marketplace.search.dm.dto.OutputGlobalSearchDataDto;
import com.finconsgroup.itserr.marketplace.search.dm.dto.ProgramConductorDto;
import com.finconsgroup.itserr.marketplace.search.dm.dto.ProgramSubscribedParticipantDto;
import com.finconsgroup.itserr.marketplace.search.dm.dto.SubscribedProgramDto;
import com.finconsgroup.itserr.marketplace.search.dm.entity.Event;
import com.finconsgroup.itserr.marketplace.search.dm.entity.EventConductor;
import com.finconsgroup.itserr.marketplace.search.dm.entity.ImageMinimal;
import com.finconsgroup.itserr.marketplace.search.dm.entity.InstitutionalPageMinimal;
import com.finconsgroup.itserr.marketplace.search.dm.entity.Location;
import com.finconsgroup.itserr.marketplace.search.dm.entity.ProgramConductor;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import javax.annotation.processing.Generated;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Generated(
    value = "org.mapstruct.ap.MappingProcessor",
    date = "2025-12-29T11:38:01+0000",
    comments = "version: 1.6.3, compiler: javac, environment: Java 21.0.9 (Eclipse Adoptium)"
)
@Component
public class EventMapperImpl implements EventMapper {

    @Autowired
    private UserProfileMapper userProfileMapper;

    @Override
    public Event toEntity(InputEventDto dto) {
        if ( dto == null ) {
            return null;
        }

        Event.EventBuilder event = Event.builder();

        event.id( dto.getId() );
        event.title( dto.getTitle() );
        event.eventLink( dto.getEventLink() );
        event.eventType( dto.getEventType() );
        event.content( dto.getContent() );
        event.subscribedParticipantsCount( dto.getSubscribedParticipantsCount() );
        List<String> list = dto.getTags();
        if ( list != null ) {
            event.tags( new ArrayList<String>( list ) );
        }
        event.institutionalPages( institutionalPageMinimalDtoListToInstitutionalPageMinimalList( dto.getInstitutionalPages() ) );
        event.image( imageMinimalDtoToImageMinimal( dto.getImage() ) );
        event.timezone( dto.getTimezone() );
        event.startDate( dto.getStartDate() );
        event.endDate( dto.getEndDate() );
        event.eventConductors( eventConductorDtoListToEventConductorList( dto.getEventConductors() ) );
        event.schedules( eventScheduleDtoListToScheduleList( dto.getSchedules() ) );
        event.subscribedParticipants( eventSubscribedParticipantDtoListToSubscribedParticipantList( dto.getSubscribedParticipants() ) );
        event.eventPlanner( userProfileMapper.toMinimalEntity( dto.getEventPlanner() ) );
        event.maintainer( userProfileMapper.toMinimalEntity( dto.getMaintainer() ) );
        event.creationTime( dto.getCreationTime() );
        event.updateTime( dto.getUpdateTime() );

        return event.build();
    }

    @Override
    public OutputEventDto toDto(Event entity) {
        if ( entity == null ) {
            return null;
        }

        OutputEventDto.OutputEventDtoBuilder outputEventDto = OutputEventDto.builder();

        outputEventDto.id( entity.getId() );
        outputEventDto.title( entity.getTitle() );
        outputEventDto.eventLink( entity.getEventLink() );
        outputEventDto.eventType( entity.getEventType() );
        outputEventDto.content( entity.getContent() );
        outputEventDto.subscribedParticipantsCount( entity.getSubscribedParticipantsCount() );
        List<String> list = entity.getTags();
        if ( list != null ) {
            outputEventDto.tags( new ArrayList<String>( list ) );
        }
        outputEventDto.institutionalPages( institutionalPageMinimalListToInstitutionalPageMinimalDtoList( entity.getInstitutionalPages() ) );
        outputEventDto.image( imageMinimalToImageMinimalDto( entity.getImage() ) );
        outputEventDto.timezone( entity.getTimezone() );
        outputEventDto.startDate( entity.getStartDate() );
        outputEventDto.endDate( entity.getEndDate() );
        outputEventDto.eventConductors( eventConductorListToEventConductorDtoList( entity.getEventConductors() ) );
        outputEventDto.schedules( scheduleListToEventScheduleDtoList( entity.getSchedules() ) );
        outputEventDto.subscribedParticipants( subscribedParticipantListToEventSubscribedParticipantDtoList( entity.getSubscribedParticipants() ) );
        outputEventDto.eventPlanner( userProfileMapper.toMinimalDto( entity.getEventPlanner() ) );
        outputEventDto.maintainer( userProfileMapper.toMinimalDto( entity.getMaintainer() ) );
        outputEventDto.creationTime( entity.getCreationTime() );
        outputEventDto.updateTime( entity.getUpdateTime() );

        return outputEventDto.build();
    }

    @Override
    public OutputGlobalSearchAutoCompleteDataDto toAutoCompleteDataDto(Event entity) {
        if ( entity == null ) {
            return null;
        }

        OutputGlobalSearchAutoCompleteDataDto.OutputGlobalSearchAutoCompleteDataDtoBuilder outputGlobalSearchAutoCompleteDataDto = OutputGlobalSearchAutoCompleteDataDto.builder();

        outputGlobalSearchAutoCompleteDataDto.id( entity.getId() );
        outputGlobalSearchAutoCompleteDataDto.title( entity.getTitle() );
        outputGlobalSearchAutoCompleteDataDto.score( entity.getScore() );

        return outputGlobalSearchAutoCompleteDataDto.build();
    }

    @Override
    public OutputEventLocalSearchDto toLocalSearchDto(Event entity) {
        if ( entity == null ) {
            return null;
        }

        OutputEventLocalSearchDto.OutputEventLocalSearchDtoBuilder outputEventLocalSearchDto = OutputEventLocalSearchDto.builder();

        outputEventLocalSearchDto.id( entity.getId() );
        outputEventLocalSearchDto.title( entity.getTitle() );
        outputEventLocalSearchDto.eventLink( entity.getEventLink() );
        outputEventLocalSearchDto.eventType( entity.getEventType() );
        outputEventLocalSearchDto.content( entity.getContent() );
        List<String> list = entity.getTags();
        if ( list != null ) {
            outputEventLocalSearchDto.tags( new ArrayList<String>( list ) );
        }
        outputEventLocalSearchDto.institutionalPages( institutionalPageMinimalListToInstitutionalPageMinimalDtoList( entity.getInstitutionalPages() ) );
        outputEventLocalSearchDto.image( imageMinimalToImageMinimalDto( entity.getImage() ) );
        outputEventLocalSearchDto.timezone( entity.getTimezone() );
        outputEventLocalSearchDto.startDate( entity.getStartDate() );
        outputEventLocalSearchDto.endDate( entity.getEndDate() );
        outputEventLocalSearchDto.schedules( scheduleListToEventScheduleDtoList( entity.getSchedules() ) );
        outputEventLocalSearchDto.eventPlanner( userProfileMapper.toMinimalDto( entity.getEventPlanner() ) );
        outputEventLocalSearchDto.maintainer( userProfileMapper.toMinimalDto( entity.getMaintainer() ) );
        outputEventLocalSearchDto.creationTime( entity.getCreationTime() );
        outputEventLocalSearchDto.updateTime( entity.getUpdateTime() );

        return outputEventLocalSearchDto.build();
    }

    @Override
    public OutputGlobalSearchDataDto toGlobalSearchDataDto(Event entity) {
        if ( entity == null ) {
            return null;
        }

        OutputGlobalSearchDataDto.OutputGlobalSearchDataDtoBuilder outputGlobalSearchDataDto = OutputGlobalSearchDataDto.builder();

        outputGlobalSearchDataDto.description( entity.getContent() );
        outputGlobalSearchDataDto.imageUrl( entityImageUrl( entity ) );
        outputGlobalSearchDataDto.id( entity.getId() );
        outputGlobalSearchDataDto.title( entity.getTitle() );
        outputGlobalSearchDataDto.score( entity.getScore() );

        return outputGlobalSearchDataDto.build();
    }

    protected InstitutionalPageMinimal institutionalPageMinimalDtoToInstitutionalPageMinimal(InstitutionalPageMinimalDto institutionalPageMinimalDto) {
        if ( institutionalPageMinimalDto == null ) {
            return null;
        }

        InstitutionalPageMinimal.InstitutionalPageMinimalBuilder institutionalPageMinimal = InstitutionalPageMinimal.builder();

        institutionalPageMinimal.id( institutionalPageMinimalDto.getId() );
        institutionalPageMinimal.name( institutionalPageMinimalDto.getName() );

        return institutionalPageMinimal.build();
    }

    protected List<InstitutionalPageMinimal> institutionalPageMinimalDtoListToInstitutionalPageMinimalList(List<InstitutionalPageMinimalDto> list) {
        if ( list == null ) {
            return null;
        }

        List<InstitutionalPageMinimal> list1 = new ArrayList<InstitutionalPageMinimal>( list.size() );
        for ( InstitutionalPageMinimalDto institutionalPageMinimalDto : list ) {
            list1.add( institutionalPageMinimalDtoToInstitutionalPageMinimal( institutionalPageMinimalDto ) );
        }

        return list1;
    }

    protected ImageMinimal imageMinimalDtoToImageMinimal(ImageMinimalDto imageMinimalDto) {
        if ( imageMinimalDto == null ) {
            return null;
        }

        ImageMinimal.ImageMinimalBuilder imageMinimal = ImageMinimal.builder();

        imageMinimal.id( imageMinimalDto.getId() );
        imageMinimal.url( imageMinimalDto.getUrl() );

        return imageMinimal.build();
    }

    protected EventConductor eventConductorDtoToEventConductor(EventConductorDto eventConductorDto) {
        if ( eventConductorDto == null ) {
            return null;
        }

        EventConductor.EventConductorBuilder eventConductor = EventConductor.builder();

        eventConductor.firstName( eventConductorDto.getFirstName() );
        eventConductor.lastName( eventConductorDto.getLastName() );
        eventConductor.email( eventConductorDto.getEmail() );
        eventConductor.orcid( eventConductorDto.getOrcid() );

        return eventConductor.build();
    }

    protected List<EventConductor> eventConductorDtoListToEventConductorList(List<EventConductorDto> list) {
        if ( list == null ) {
            return null;
        }

        List<EventConductor> list1 = new ArrayList<EventConductor>( list.size() );
        for ( EventConductorDto eventConductorDto : list ) {
            list1.add( eventConductorDtoToEventConductor( eventConductorDto ) );
        }

        return list1;
    }

    protected Location locationDtoToLocation(LocationDto locationDto) {
        if ( locationDto == null ) {
            return null;
        }

        Location.LocationBuilder location = Location.builder();

        location.zipCode( locationDto.getZipCode() );
        location.city( locationDto.getCity() );
        location.region( locationDto.getRegion() );
        location.country( locationDto.getCountry() );

        return location.build();
    }

    protected ProgramConductor programConductorDtoToProgramConductor(ProgramConductorDto programConductorDto) {
        if ( programConductorDto == null ) {
            return null;
        }

        ProgramConductor.ProgramConductorBuilder programConductor = ProgramConductor.builder();

        programConductor.firstName( programConductorDto.getFirstName() );
        programConductor.lastName( programConductorDto.getLastName() );
        programConductor.email( programConductorDto.getEmail() );
        programConductor.orcid( programConductorDto.getOrcid() );

        return programConductor.build();
    }

    protected List<ProgramConductor> programConductorDtoListToProgramConductorList(List<ProgramConductorDto> list) {
        if ( list == null ) {
            return null;
        }

        List<ProgramConductor> list1 = new ArrayList<ProgramConductor>( list.size() );
        for ( ProgramConductorDto programConductorDto : list ) {
            list1.add( programConductorDtoToProgramConductor( programConductorDto ) );
        }

        return list1;
    }

    protected Event.ProgramSubscribedParticipant programSubscribedParticipantDtoToProgramSubscribedParticipant(ProgramSubscribedParticipantDto programSubscribedParticipantDto) {
        if ( programSubscribedParticipantDto == null ) {
            return null;
        }

        Event.ProgramSubscribedParticipant.ProgramSubscribedParticipantBuilder programSubscribedParticipant = Event.ProgramSubscribedParticipant.builder();

        if ( programSubscribedParticipantDto.getId() != null ) {
            programSubscribedParticipant.id( programSubscribedParticipantDto.getId().toString() );
        }
        if ( programSubscribedParticipantDto.getProgramId() != null ) {
            programSubscribedParticipant.programId( programSubscribedParticipantDto.getProgramId().toString() );
        }
        if ( programSubscribedParticipantDto.getUserId() != null ) {
            programSubscribedParticipant.userId( programSubscribedParticipantDto.getUserId().toString() );
        }
        programSubscribedParticipant.remoteParticipation( programSubscribedParticipantDto.getRemoteParticipation() );
        programSubscribedParticipant.creationTime( programSubscribedParticipantDto.getCreationTime() );
        programSubscribedParticipant.updateTime( programSubscribedParticipantDto.getUpdateTime() );

        return programSubscribedParticipant.build();
    }

    protected List<Event.ProgramSubscribedParticipant> programSubscribedParticipantDtoListToProgramSubscribedParticipantList(List<ProgramSubscribedParticipantDto> list) {
        if ( list == null ) {
            return null;
        }

        List<Event.ProgramSubscribedParticipant> list1 = new ArrayList<Event.ProgramSubscribedParticipant>( list.size() );
        for ( ProgramSubscribedParticipantDto programSubscribedParticipantDto : list ) {
            list1.add( programSubscribedParticipantDtoToProgramSubscribedParticipant( programSubscribedParticipantDto ) );
        }

        return list1;
    }

    protected Event.Program eventProgramDtoToProgram(EventProgramDto eventProgramDto) {
        if ( eventProgramDto == null ) {
            return null;
        }

        Event.Program.ProgramBuilder program = Event.Program.builder();

        program.title( eventProgramDto.getTitle() );
        program.description( eventProgramDto.getDescription() );
        program.programLink( eventProgramDto.getProgramLink() );
        program.programConductors( programConductorDtoListToProgramConductorList( eventProgramDto.getProgramConductors() ) );
        program.place( eventProgramDto.getPlace() );
        program.street( eventProgramDto.getStreet() );
        program.maxParticipants( eventProgramDto.getMaxParticipants() );
        program.subscribedParticipantsCount( eventProgramDto.getSubscribedParticipantsCount() );
        program.subscribedParticipants( programSubscribedParticipantDtoListToProgramSubscribedParticipantList( eventProgramDto.getSubscribedParticipants() ) );
        program.startTime( eventProgramDto.getStartTime() );
        program.endTime( eventProgramDto.getEndTime() );

        return program.build();
    }

    protected List<Event.Program> eventProgramDtoListToProgramList(List<EventProgramDto> list) {
        if ( list == null ) {
            return null;
        }

        List<Event.Program> list1 = new ArrayList<Event.Program>( list.size() );
        for ( EventProgramDto eventProgramDto : list ) {
            list1.add( eventProgramDtoToProgram( eventProgramDto ) );
        }

        return list1;
    }

    protected Event.Schedule eventScheduleDtoToSchedule(EventScheduleDto eventScheduleDto) {
        if ( eventScheduleDto == null ) {
            return null;
        }

        Event.Schedule.ScheduleBuilder schedule = Event.Schedule.builder();

        schedule.title( eventScheduleDto.getTitle() );
        schedule.description( eventScheduleDto.getDescription() );
        schedule.startDate( eventScheduleDto.getStartDate() );
        schedule.startTime( eventScheduleDto.getStartTime() );
        schedule.endTime( eventScheduleDto.getEndTime() );
        schedule.location( locationDtoToLocation( eventScheduleDto.getLocation() ) );
        schedule.programs( eventProgramDtoListToProgramList( eventScheduleDto.getPrograms() ) );

        return schedule.build();
    }

    protected List<Event.Schedule> eventScheduleDtoListToScheduleList(List<EventScheduleDto> list) {
        if ( list == null ) {
            return null;
        }

        List<Event.Schedule> list1 = new ArrayList<Event.Schedule>( list.size() );
        for ( EventScheduleDto eventScheduleDto : list ) {
            list1.add( eventScheduleDtoToSchedule( eventScheduleDto ) );
        }

        return list1;
    }

    protected Event.SubscribedProgram subscribedProgramDtoToSubscribedProgram(SubscribedProgramDto subscribedProgramDto) {
        if ( subscribedProgramDto == null ) {
            return null;
        }

        Event.SubscribedProgram.SubscribedProgramBuilder subscribedProgram = Event.SubscribedProgram.builder();

        if ( subscribedProgramDto.getId() != null ) {
            subscribedProgram.id( subscribedProgramDto.getId().toString() );
        }
        subscribedProgram.title( subscribedProgramDto.getTitle() );
        subscribedProgram.description( subscribedProgramDto.getDescription() );
        subscribedProgram.remoteParticipation( subscribedProgramDto.getRemoteParticipation() );

        return subscribedProgram.build();
    }

    protected List<Event.SubscribedProgram> subscribedProgramDtoListToSubscribedProgramList(List<SubscribedProgramDto> list) {
        if ( list == null ) {
            return null;
        }

        List<Event.SubscribedProgram> list1 = new ArrayList<Event.SubscribedProgram>( list.size() );
        for ( SubscribedProgramDto subscribedProgramDto : list ) {
            list1.add( subscribedProgramDtoToSubscribedProgram( subscribedProgramDto ) );
        }

        return list1;
    }

    protected Event.SubscribedParticipant eventSubscribedParticipantDtoToSubscribedParticipant(EventSubscribedParticipantDto eventSubscribedParticipantDto) {
        if ( eventSubscribedParticipantDto == null ) {
            return null;
        }

        Event.SubscribedParticipant.SubscribedParticipantBuilder subscribedParticipant = Event.SubscribedParticipant.builder();

        subscribedParticipant.id( eventSubscribedParticipantDto.getId() );
        subscribedParticipant.eventId( eventSubscribedParticipantDto.getEventId() );
        subscribedParticipant.userId( eventSubscribedParticipantDto.getUserId() );
        subscribedParticipant.firstName( eventSubscribedParticipantDto.getFirstName() );
        subscribedParticipant.lastName( eventSubscribedParticipantDto.getLastName() );
        subscribedParticipant.email( eventSubscribedParticipantDto.getEmail() );
        subscribedParticipant.orcid( eventSubscribedParticipantDto.getOrcid() );
        subscribedParticipant.subscribedPrograms( subscribedProgramDtoListToSubscribedProgramList( eventSubscribedParticipantDto.getSubscribedPrograms() ) );
        subscribedParticipant.creationTime( eventSubscribedParticipantDto.getCreationTime() );
        subscribedParticipant.updateTime( eventSubscribedParticipantDto.getUpdateTime() );

        return subscribedParticipant.build();
    }

    protected List<Event.SubscribedParticipant> eventSubscribedParticipantDtoListToSubscribedParticipantList(List<EventSubscribedParticipantDto> list) {
        if ( list == null ) {
            return null;
        }

        List<Event.SubscribedParticipant> list1 = new ArrayList<Event.SubscribedParticipant>( list.size() );
        for ( EventSubscribedParticipantDto eventSubscribedParticipantDto : list ) {
            list1.add( eventSubscribedParticipantDtoToSubscribedParticipant( eventSubscribedParticipantDto ) );
        }

        return list1;
    }

    protected InstitutionalPageMinimalDto institutionalPageMinimalToInstitutionalPageMinimalDto(InstitutionalPageMinimal institutionalPageMinimal) {
        if ( institutionalPageMinimal == null ) {
            return null;
        }

        InstitutionalPageMinimalDto.InstitutionalPageMinimalDtoBuilder institutionalPageMinimalDto = InstitutionalPageMinimalDto.builder();

        institutionalPageMinimalDto.id( institutionalPageMinimal.getId() );
        institutionalPageMinimalDto.name( institutionalPageMinimal.getName() );

        return institutionalPageMinimalDto.build();
    }

    protected List<InstitutionalPageMinimalDto> institutionalPageMinimalListToInstitutionalPageMinimalDtoList(List<InstitutionalPageMinimal> list) {
        if ( list == null ) {
            return null;
        }

        List<InstitutionalPageMinimalDto> list1 = new ArrayList<InstitutionalPageMinimalDto>( list.size() );
        for ( InstitutionalPageMinimal institutionalPageMinimal : list ) {
            list1.add( institutionalPageMinimalToInstitutionalPageMinimalDto( institutionalPageMinimal ) );
        }

        return list1;
    }

    protected ImageMinimalDto imageMinimalToImageMinimalDto(ImageMinimal imageMinimal) {
        if ( imageMinimal == null ) {
            return null;
        }

        ImageMinimalDto.ImageMinimalDtoBuilder<?, ?> imageMinimalDto = ImageMinimalDto.builder();

        imageMinimalDto.id( imageMinimal.getId() );
        imageMinimalDto.url( imageMinimal.getUrl() );

        return imageMinimalDto.build();
    }

    protected EventConductorDto eventConductorToEventConductorDto(EventConductor eventConductor) {
        if ( eventConductor == null ) {
            return null;
        }

        EventConductorDto.EventConductorDtoBuilder eventConductorDto = EventConductorDto.builder();

        eventConductorDto.firstName( eventConductor.getFirstName() );
        eventConductorDto.lastName( eventConductor.getLastName() );
        eventConductorDto.email( eventConductor.getEmail() );
        eventConductorDto.orcid( eventConductor.getOrcid() );

        return eventConductorDto.build();
    }

    protected List<EventConductorDto> eventConductorListToEventConductorDtoList(List<EventConductor> list) {
        if ( list == null ) {
            return null;
        }

        List<EventConductorDto> list1 = new ArrayList<EventConductorDto>( list.size() );
        for ( EventConductor eventConductor : list ) {
            list1.add( eventConductorToEventConductorDto( eventConductor ) );
        }

        return list1;
    }

    protected LocationDto locationToLocationDto(Location location) {
        if ( location == null ) {
            return null;
        }

        LocationDto.LocationDtoBuilder locationDto = LocationDto.builder();

        locationDto.zipCode( location.getZipCode() );
        locationDto.city( location.getCity() );
        locationDto.region( location.getRegion() );
        locationDto.country( location.getCountry() );

        return locationDto.build();
    }

    protected ProgramConductorDto programConductorToProgramConductorDto(ProgramConductor programConductor) {
        if ( programConductor == null ) {
            return null;
        }

        ProgramConductorDto.ProgramConductorDtoBuilder programConductorDto = ProgramConductorDto.builder();

        programConductorDto.firstName( programConductor.getFirstName() );
        programConductorDto.lastName( programConductor.getLastName() );
        programConductorDto.email( programConductor.getEmail() );
        programConductorDto.orcid( programConductor.getOrcid() );

        return programConductorDto.build();
    }

    protected List<ProgramConductorDto> programConductorListToProgramConductorDtoList(List<ProgramConductor> list) {
        if ( list == null ) {
            return null;
        }

        List<ProgramConductorDto> list1 = new ArrayList<ProgramConductorDto>( list.size() );
        for ( ProgramConductor programConductor : list ) {
            list1.add( programConductorToProgramConductorDto( programConductor ) );
        }

        return list1;
    }

    protected ProgramSubscribedParticipantDto programSubscribedParticipantToProgramSubscribedParticipantDto(Event.ProgramSubscribedParticipant programSubscribedParticipant) {
        if ( programSubscribedParticipant == null ) {
            return null;
        }

        ProgramSubscribedParticipantDto.ProgramSubscribedParticipantDtoBuilder<?, ?> programSubscribedParticipantDto = ProgramSubscribedParticipantDto.builder();

        if ( programSubscribedParticipant.getId() != null ) {
            programSubscribedParticipantDto.id( UUID.fromString( programSubscribedParticipant.getId() ) );
        }
        if ( programSubscribedParticipant.getProgramId() != null ) {
            programSubscribedParticipantDto.programId( UUID.fromString( programSubscribedParticipant.getProgramId() ) );
        }
        if ( programSubscribedParticipant.getUserId() != null ) {
            programSubscribedParticipantDto.userId( UUID.fromString( programSubscribedParticipant.getUserId() ) );
        }
        programSubscribedParticipantDto.remoteParticipation( programSubscribedParticipant.getRemoteParticipation() );
        programSubscribedParticipantDto.creationTime( programSubscribedParticipant.getCreationTime() );
        programSubscribedParticipantDto.updateTime( programSubscribedParticipant.getUpdateTime() );

        return programSubscribedParticipantDto.build();
    }

    protected List<ProgramSubscribedParticipantDto> programSubscribedParticipantListToProgramSubscribedParticipantDtoList(List<Event.ProgramSubscribedParticipant> list) {
        if ( list == null ) {
            return null;
        }

        List<ProgramSubscribedParticipantDto> list1 = new ArrayList<ProgramSubscribedParticipantDto>( list.size() );
        for ( Event.ProgramSubscribedParticipant programSubscribedParticipant : list ) {
            list1.add( programSubscribedParticipantToProgramSubscribedParticipantDto( programSubscribedParticipant ) );
        }

        return list1;
    }

    protected EventProgramDto programToEventProgramDto(Event.Program program) {
        if ( program == null ) {
            return null;
        }

        EventProgramDto.EventProgramDtoBuilder<?, ?> eventProgramDto = EventProgramDto.builder();

        eventProgramDto.title( program.getTitle() );
        eventProgramDto.description( program.getDescription() );
        eventProgramDto.programLink( program.getProgramLink() );
        eventProgramDto.programConductors( programConductorListToProgramConductorDtoList( program.getProgramConductors() ) );
        eventProgramDto.place( program.getPlace() );
        eventProgramDto.street( program.getStreet() );
        eventProgramDto.maxParticipants( program.getMaxParticipants() );
        eventProgramDto.subscribedParticipants( programSubscribedParticipantListToProgramSubscribedParticipantDtoList( program.getSubscribedParticipants() ) );
        eventProgramDto.subscribedParticipantsCount( program.getSubscribedParticipantsCount() );
        eventProgramDto.startTime( program.getStartTime() );
        eventProgramDto.endTime( program.getEndTime() );

        return eventProgramDto.build();
    }

    protected List<EventProgramDto> programListToEventProgramDtoList(List<Event.Program> list) {
        if ( list == null ) {
            return null;
        }

        List<EventProgramDto> list1 = new ArrayList<EventProgramDto>( list.size() );
        for ( Event.Program program : list ) {
            list1.add( programToEventProgramDto( program ) );
        }

        return list1;
    }

    protected EventScheduleDto scheduleToEventScheduleDto(Event.Schedule schedule) {
        if ( schedule == null ) {
            return null;
        }

        EventScheduleDto.EventScheduleDtoBuilder<?, ?> eventScheduleDto = EventScheduleDto.builder();

        eventScheduleDto.title( schedule.getTitle() );
        eventScheduleDto.description( schedule.getDescription() );
        eventScheduleDto.startDate( schedule.getStartDate() );
        eventScheduleDto.startTime( schedule.getStartTime() );
        eventScheduleDto.endTime( schedule.getEndTime() );
        eventScheduleDto.location( locationToLocationDto( schedule.getLocation() ) );
        eventScheduleDto.programs( programListToEventProgramDtoList( schedule.getPrograms() ) );

        return eventScheduleDto.build();
    }

    protected List<EventScheduleDto> scheduleListToEventScheduleDtoList(List<Event.Schedule> list) {
        if ( list == null ) {
            return null;
        }

        List<EventScheduleDto> list1 = new ArrayList<EventScheduleDto>( list.size() );
        for ( Event.Schedule schedule : list ) {
            list1.add( scheduleToEventScheduleDto( schedule ) );
        }

        return list1;
    }

    protected SubscribedProgramDto subscribedProgramToSubscribedProgramDto(Event.SubscribedProgram subscribedProgram) {
        if ( subscribedProgram == null ) {
            return null;
        }

        SubscribedProgramDto.SubscribedProgramDtoBuilder<?, ?> subscribedProgramDto = SubscribedProgramDto.builder();

        if ( subscribedProgram.getId() != null ) {
            subscribedProgramDto.id( UUID.fromString( subscribedProgram.getId() ) );
        }
        subscribedProgramDto.title( subscribedProgram.getTitle() );
        subscribedProgramDto.description( subscribedProgram.getDescription() );
        subscribedProgramDto.remoteParticipation( subscribedProgram.getRemoteParticipation() );

        return subscribedProgramDto.build();
    }

    protected List<SubscribedProgramDto> subscribedProgramListToSubscribedProgramDtoList(List<Event.SubscribedProgram> list) {
        if ( list == null ) {
            return null;
        }

        List<SubscribedProgramDto> list1 = new ArrayList<SubscribedProgramDto>( list.size() );
        for ( Event.SubscribedProgram subscribedProgram : list ) {
            list1.add( subscribedProgramToSubscribedProgramDto( subscribedProgram ) );
        }

        return list1;
    }

    protected EventSubscribedParticipantDto subscribedParticipantToEventSubscribedParticipantDto(Event.SubscribedParticipant subscribedParticipant) {
        if ( subscribedParticipant == null ) {
            return null;
        }

        EventSubscribedParticipantDto.EventSubscribedParticipantDtoBuilder<?, ?> eventSubscribedParticipantDto = EventSubscribedParticipantDto.builder();

        eventSubscribedParticipantDto.id( subscribedParticipant.getId() );
        eventSubscribedParticipantDto.eventId( subscribedParticipant.getEventId() );
        eventSubscribedParticipantDto.userId( subscribedParticipant.getUserId() );
        eventSubscribedParticipantDto.firstName( subscribedParticipant.getFirstName() );
        eventSubscribedParticipantDto.lastName( subscribedParticipant.getLastName() );
        eventSubscribedParticipantDto.email( subscribedParticipant.getEmail() );
        eventSubscribedParticipantDto.orcid( subscribedParticipant.getOrcid() );
        eventSubscribedParticipantDto.subscribedPrograms( subscribedProgramListToSubscribedProgramDtoList( subscribedParticipant.getSubscribedPrograms() ) );
        eventSubscribedParticipantDto.creationTime( subscribedParticipant.getCreationTime() );
        eventSubscribedParticipantDto.updateTime( subscribedParticipant.getUpdateTime() );

        return eventSubscribedParticipantDto.build();
    }

    protected List<EventSubscribedParticipantDto> subscribedParticipantListToEventSubscribedParticipantDtoList(List<Event.SubscribedParticipant> list) {
        if ( list == null ) {
            return null;
        }

        List<EventSubscribedParticipantDto> list1 = new ArrayList<EventSubscribedParticipantDto>( list.size() );
        for ( Event.SubscribedParticipant subscribedParticipant : list ) {
            list1.add( subscribedParticipantToEventSubscribedParticipantDto( subscribedParticipant ) );
        }

        return list1;
    }

    private String entityImageUrl(Event event) {
        ImageMinimal image = event.getImage();
        if ( image == null ) {
            return null;
        }
        return image.getUrl();
    }
}
