/*
 * Decompiled with CFR 0.152.
 */
package com.finconsgroup.itserr.marketplace.search.bs.messaging;

import com.finconsgroup.itserr.marketplace.search.bs.messaging.EntityIdWrapper;
import com.finconsgroup.itserr.messaging.consumer.handler.ConsumerMessageHandler;
import com.finconsgroup.itserr.messaging.exception.WP2MessagingException;
import com.finconsgroup.itserr.messaging.utils.CloudEventUtil;
import io.cloudevents.CloudEvent;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.StringUtils;

public abstract class AbstractResourceSubscriber
implements ConsumerMessageHandler {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(AbstractResourceSubscriber.class);

    protected abstract void handleResource(String var1, Object var2, String var3);

    public void handleMessage(CloudEvent cloudEvent) {
        try {
            if (!StringUtils.hasText((String)cloudEvent.getId())) {
                throw new IllegalArgumentException("resource Id can not be null");
            }
            log.info("Received message for ingestion with cloudEventId: {}", (Object)cloudEvent.getId());
            Object eventData = CloudEventUtil.extractData((CloudEvent)cloudEvent);
            EntityIdWrapper entityIdWrapper = (EntityIdWrapper)CloudEventUtil.getObjectMapper().convertValue(eventData, EntityIdWrapper.class);
            if (!StringUtils.hasText((String)entityIdWrapper.getId())) {
                throw new IllegalArgumentException("resource entity Id can not be null");
            }
            this.handleResource(entityIdWrapper.getId(), eventData, cloudEvent.getType());
        }
        catch (Exception e) {
            log.info("handleMessage error: {}", (Object)e.getMessage());
            throw new WP2MessagingException((Throwable)e);
        }
    }
}

