package com.finconsgroup.itserr.marketplace.search.bs.config.properties;

import jakarta.validation.Valid;
import jakarta.validation.constraints.NotBlank;
import jakarta.validation.constraints.NotNull;
import lombok.Data;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.validation.annotation.Validated;

/**
 * Configuration properties for the search bs service.
 * <p>
 * These properties are mapped from the {@code search.bs} prefix in the application configuration.
 */
@Data
@Validated
@ConfigurationProperties(prefix = "search.bs")
public class SearchBsConfigurationProperties {

    /**
     * Base URL used by Swagger/OpenAPI documentation.
     * Example: {@code http://localhost:8080}
     */
    @NotBlank
    private String swaggerApiServerUrl;

    /**
     * True if integration tests should fail when Docker is not running
     */
    @NotNull
    private Boolean failsTestsOnMissingDocker;

    /**
     * Messaging-related configuration properties.
     */
    @NotNull
    @Valid
    private MessagingProperties messaging;

}
