/*
 * Decompiled with CFR 0.152.
 */
package com.finconsgroup.itserr.marketplace.search.bs.messaging;

import com.finconsgroup.itserr.marketplace.search.bs.client.dm.SearchDmClient;
import com.finconsgroup.itserr.marketplace.search.bs.config.properties.MessagingCatalogBsProperties;
import com.finconsgroup.itserr.marketplace.search.bs.config.properties.SearchBsConfigurationProperties;
import com.finconsgroup.itserr.marketplace.search.bs.messaging.AbstractResourceSubscriber;
import java.util.Objects;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component(value="catalogResourceSubscriber")
public class CatalogResourceSubscriber
extends AbstractResourceSubscriber {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(CatalogResourceSubscriber.class);
    private final MessagingCatalogBsProperties messagingCatalogBsProperties;
    private final SearchDmClient searchDmClient;

    public CatalogResourceSubscriber(SearchBsConfigurationProperties searchBsConfigurationProperties, SearchDmClient searchDmClient) {
        this.messagingCatalogBsProperties = searchBsConfigurationProperties.getMessaging().getCatalogBs();
        this.searchDmClient = searchDmClient;
    }

    protected void handleResource(String resourceId, Object resourcePayload, String eventType) {
        log.debug("Processing catalog event, id: {}, payload: {}, type: {}", new Object[]{resourceId, resourcePayload, eventType});
        if (Objects.equals(eventType, this.messagingCatalogBsProperties.getResourceCreatedEventType()) || Objects.equals(eventType, this.messagingCatalogBsProperties.getResourceUpdatedEventType())) {
            this.searchDmClient.upsertCatalog(resourceId, resourcePayload);
        } else if (Objects.equals(eventType, this.messagingCatalogBsProperties.getResourceDeletedEventType())) {
            this.searchDmClient.deleteCatalog(resourceId);
        } else {
            log.error("Unsupported eventType: {} for resourceId: {}", (Object)eventType, (Object)resourceId);
        }
    }
}

