package com.finconsgroup.itserr.marketplace.notificationfeeder.bs.client.dto;

import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.validation.constraints.NotBlank;
import jakarta.validation.constraints.NotNull;
import jakarta.validation.constraints.Size;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;

import java.util.List;
import java.util.Map;

/**
 * Input DTO for creating a user notification.
 */
@Schema(name = "InputCreateUserNotificationDto", description = "DTO for creating a user notification")
@Data
@Builder
@AllArgsConstructor
public class InputCreateUserNotificationDto {

    @Schema(description = "The users receiving the notification, expressed as an id, a username or an email", example = "f81d4fae-7dec-11d0-a765-00a0c91e6bf6")
    @NotNull
    private List<String> users;

    @Schema(description = "The type of notification", example = "catalog-item-event-created")
    @NotBlank
    @Size(max = 100)
    private String type;

    @Schema(description = "ID of the referenced entity", example = "12345")
    @NotBlank
    @Size(max = 100)
    private String referencedId;

    @Schema(description = "Placeholder values for notification template")
    private Map<String, String> placeholderValues;

}
