package com.finconsgroup.itserr.marketplace.notification.dm.service;

import java.util.List;

/**
 * Service interface for managing language preferences and retrieving preferred languages for localization purposes.
 */
public interface LanguageService {

    /**
     * Retrieves an ordered list of preferred languages based on user preferences or system settings.
     *
     * @param httpAcceptLanguage HTTP Accept-Language header. May be null.
     * @return List of language codes ordered by preference
     */
    List<String> getPreferredLanguages(String httpAcceptLanguage);

}
