/*
 * Decompiled with CFR 0.152.
 */
package com.finconsgroup.itserr.marketplace.news.dm.entity;

import com.finconsgroup.itserr.marketplace.core.entity.AbstractUUIDEntity;
import com.finconsgroup.itserr.marketplace.news.dm.entity.ArchivedAuthorEntity;
import com.finconsgroup.itserr.marketplace.news.dm.entity.ArchivedNewsEntity;
import jakarta.persistence.Column;
import jakarta.persistence.Entity;
import jakarta.persistence.JoinColumn;
import jakarta.persistence.ManyToOne;
import jakarta.persistence.Table;
import java.time.Instant;
import lombok.Generated;

@Entity
@Table(name="archived_author")
public class ArchivedAuthorEntity
extends AbstractUUIDEntity {
    @ManyToOne
    @JoinColumn(name="news_id", nullable=false)
    private ArchivedNewsEntity archivedNews;
    @Column(name="first_name", nullable=false)
    private String firstName;
    @Column(name="last_name", nullable=false)
    private String lastName;
    @Column(name="email", nullable=false)
    private String email;
    @Column(name="orcid")
    private String orcid;
    @Column(name="location_city")
    private String locationCity;
    @Column(name="location_region")
    private String locationRegion;
    @Column(name="location_country")
    private String locationCountry;
    @Column(name="location_zip_code")
    private String locationZipCode;
    @Column(name="creation_time", nullable=false, updatable=false)
    private Instant creationTime;
    @Column(name="update_time", nullable=false)
    private Instant updateTime;
    @Column(name="version", nullable=false)
    private long version;

    public void prePersist() {
        super.prePersist();
        Instant now = Instant.now();
        if (this.creationTime == null) {
            this.creationTime = now;
        }
        if (this.updateTime == null) {
            this.updateTime = now;
        }
    }

    @Generated
    protected ArchivedAuthorEntity(ArchivedAuthorEntityBuilder<?, ?> b) {
        super(b);
        this.archivedNews = b.archivedNews;
        this.firstName = b.firstName;
        this.lastName = b.lastName;
        this.email = b.email;
        this.orcid = b.orcid;
        this.locationCity = b.locationCity;
        this.locationRegion = b.locationRegion;
        this.locationCountry = b.locationCountry;
        this.locationZipCode = b.locationZipCode;
        this.creationTime = b.creationTime;
        this.updateTime = b.updateTime;
        this.version = b.version;
    }

    @Generated
    public static ArchivedAuthorEntityBuilder<?, ?> builder() {
        return new ArchivedAuthorEntityBuilderImpl();
    }

    @Generated
    public ArchivedNewsEntity getArchivedNews() {
        return this.archivedNews;
    }

    @Generated
    public String getFirstName() {
        return this.firstName;
    }

    @Generated
    public String getLastName() {
        return this.lastName;
    }

    @Generated
    public String getEmail() {
        return this.email;
    }

    @Generated
    public String getOrcid() {
        return this.orcid;
    }

    @Generated
    public String getLocationCity() {
        return this.locationCity;
    }

    @Generated
    public String getLocationRegion() {
        return this.locationRegion;
    }

    @Generated
    public String getLocationCountry() {
        return this.locationCountry;
    }

    @Generated
    public String getLocationZipCode() {
        return this.locationZipCode;
    }

    @Generated
    public Instant getCreationTime() {
        return this.creationTime;
    }

    @Generated
    public Instant getUpdateTime() {
        return this.updateTime;
    }

    @Generated
    public long getVersion() {
        return this.version;
    }

    @Generated
    public void setArchivedNews(ArchivedNewsEntity archivedNews) {
        this.archivedNews = archivedNews;
    }

    @Generated
    public void setFirstName(String firstName) {
        this.firstName = firstName;
    }

    @Generated
    public void setLastName(String lastName) {
        this.lastName = lastName;
    }

    @Generated
    public void setEmail(String email) {
        this.email = email;
    }

    @Generated
    public void setOrcid(String orcid) {
        this.orcid = orcid;
    }

    @Generated
    public void setLocationCity(String locationCity) {
        this.locationCity = locationCity;
    }

    @Generated
    public void setLocationRegion(String locationRegion) {
        this.locationRegion = locationRegion;
    }

    @Generated
    public void setLocationCountry(String locationCountry) {
        this.locationCountry = locationCountry;
    }

    @Generated
    public void setLocationZipCode(String locationZipCode) {
        this.locationZipCode = locationZipCode;
    }

    @Generated
    public void setCreationTime(Instant creationTime) {
        this.creationTime = creationTime;
    }

    @Generated
    public void setUpdateTime(Instant updateTime) {
        this.updateTime = updateTime;
    }

    @Generated
    public void setVersion(long version) {
        this.version = version;
    }

    @Generated
    public String toString() {
        return "ArchivedAuthorEntity(archivedNews=" + String.valueOf(this.getArchivedNews()) + ", firstName=" + this.getFirstName() + ", lastName=" + this.getLastName() + ", email=" + this.getEmail() + ", orcid=" + this.getOrcid() + ", locationCity=" + this.getLocationCity() + ", locationRegion=" + this.getLocationRegion() + ", locationCountry=" + this.getLocationCountry() + ", locationZipCode=" + this.getLocationZipCode() + ", creationTime=" + String.valueOf(this.getCreationTime()) + ", updateTime=" + String.valueOf(this.getUpdateTime()) + ", version=" + this.getVersion() + ")";
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ArchivedAuthorEntity)) {
            return false;
        }
        ArchivedAuthorEntity other = (ArchivedAuthorEntity)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        if (this.getVersion() != other.getVersion()) {
            return false;
        }
        String this$firstName = this.getFirstName();
        String other$firstName = other.getFirstName();
        if (this$firstName == null ? other$firstName != null : !this$firstName.equals(other$firstName)) {
            return false;
        }
        String this$lastName = this.getLastName();
        String other$lastName = other.getLastName();
        if (this$lastName == null ? other$lastName != null : !this$lastName.equals(other$lastName)) {
            return false;
        }
        String this$email = this.getEmail();
        String other$email = other.getEmail();
        if (this$email == null ? other$email != null : !this$email.equals(other$email)) {
            return false;
        }
        String this$orcid = this.getOrcid();
        String other$orcid = other.getOrcid();
        if (this$orcid == null ? other$orcid != null : !this$orcid.equals(other$orcid)) {
            return false;
        }
        String this$locationCity = this.getLocationCity();
        String other$locationCity = other.getLocationCity();
        if (this$locationCity == null ? other$locationCity != null : !this$locationCity.equals(other$locationCity)) {
            return false;
        }
        String this$locationRegion = this.getLocationRegion();
        String other$locationRegion = other.getLocationRegion();
        if (this$locationRegion == null ? other$locationRegion != null : !this$locationRegion.equals(other$locationRegion)) {
            return false;
        }
        String this$locationCountry = this.getLocationCountry();
        String other$locationCountry = other.getLocationCountry();
        if (this$locationCountry == null ? other$locationCountry != null : !this$locationCountry.equals(other$locationCountry)) {
            return false;
        }
        String this$locationZipCode = this.getLocationZipCode();
        String other$locationZipCode = other.getLocationZipCode();
        if (this$locationZipCode == null ? other$locationZipCode != null : !this$locationZipCode.equals(other$locationZipCode)) {
            return false;
        }
        Instant this$creationTime = this.getCreationTime();
        Instant other$creationTime = other.getCreationTime();
        if (this$creationTime == null ? other$creationTime != null : !((Object)this$creationTime).equals(other$creationTime)) {
            return false;
        }
        Instant this$updateTime = this.getUpdateTime();
        Instant other$updateTime = other.getUpdateTime();
        return !(this$updateTime == null ? other$updateTime != null : !((Object)this$updateTime).equals(other$updateTime));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof ArchivedAuthorEntity;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        long $version = this.getVersion();
        result = result * 59 + (int)($version >>> 32 ^ $version);
        String $firstName = this.getFirstName();
        result = result * 59 + ($firstName == null ? 43 : $firstName.hashCode());
        String $lastName = this.getLastName();
        result = result * 59 + ($lastName == null ? 43 : $lastName.hashCode());
        String $email = this.getEmail();
        result = result * 59 + ($email == null ? 43 : $email.hashCode());
        String $orcid = this.getOrcid();
        result = result * 59 + ($orcid == null ? 43 : $orcid.hashCode());
        String $locationCity = this.getLocationCity();
        result = result * 59 + ($locationCity == null ? 43 : $locationCity.hashCode());
        String $locationRegion = this.getLocationRegion();
        result = result * 59 + ($locationRegion == null ? 43 : $locationRegion.hashCode());
        String $locationCountry = this.getLocationCountry();
        result = result * 59 + ($locationCountry == null ? 43 : $locationCountry.hashCode());
        String $locationZipCode = this.getLocationZipCode();
        result = result * 59 + ($locationZipCode == null ? 43 : $locationZipCode.hashCode());
        Instant $creationTime = this.getCreationTime();
        result = result * 59 + ($creationTime == null ? 43 : ((Object)$creationTime).hashCode());
        Instant $updateTime = this.getUpdateTime();
        result = result * 59 + ($updateTime == null ? 43 : ((Object)$updateTime).hashCode());
        return result;
    }

    @Generated
    public ArchivedAuthorEntity() {
    }
}

