package com.finconsgroup.itserr.marketplace.news.dm.mapper;

import com.finconsgroup.itserr.marketplace.news.dm.dto.InputAuthorDto;
import com.finconsgroup.itserr.marketplace.news.dm.dto.OutputAuthorDto;
import com.finconsgroup.itserr.marketplace.news.dm.entity.AuthorEntity;
import org.mapstruct.Mapper;
import org.mapstruct.Mapping;

@Mapper(config = MapperConfiguration.class)
public interface AuthorMapper {

    @Mapping(target = "id", ignore = true)
    @Mapping(target = "creationTime", ignore = true)
    @Mapping(target = "updateTime", ignore = true)
    @Mapping(target = "version", ignore = true)
    @Mapping(target = "news", ignore = true)
    @Mapping(target = "locationCity", source = "location.city")
    @Mapping(target = "locationRegion", source = "location.region")
    @Mapping(target = "locationCountry", source = "location.country")
    @Mapping(target = "locationZipCode", source = "location.zipCode")
    AuthorEntity toEntity(InputAuthorDto inputAuthorDto);


    @Mapping(target = "location.city", source = "locationCity")
    @Mapping(target = "location.region", source = "locationRegion")
    @Mapping(target = "location.country", source = "locationCountry")
    @Mapping(target = "location.zipCode", source = "locationZipCode")
    OutputAuthorDto toDto(AuthorEntity authorEntity);
}
