/*
 * Decompiled with CFR 0.152.
 */
package com.finconsgroup.itserr.marketplace.news.dm.mapper;

import com.finconsgroup.itserr.marketplace.news.dm.entity.ArchivedAuthorEntity;
import com.finconsgroup.itserr.marketplace.news.dm.entity.ArchivedNewsEntity;
import com.finconsgroup.itserr.marketplace.news.dm.entity.AuthorEntity;
import com.finconsgroup.itserr.marketplace.news.dm.entity.NewsEntity;
import com.finconsgroup.itserr.marketplace.news.dm.mapper.ArchivedAuthorMapper;
import com.finconsgroup.itserr.marketplace.news.dm.mapper.ArchivedNewsMapper;
import java.util.ArrayList;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class ArchivedNewsMapperImpl
implements ArchivedNewsMapper {
    @Autowired
    private ArchivedAuthorMapper archivedAuthorMapper;

    public ArchivedNewsEntity toArchivedEntity(NewsEntity src) {
        List list1;
        if (src == null) {
            return null;
        }
        ArchivedNewsEntity.ArchivedNewsEntityBuilder archivedNewsEntity = ArchivedNewsEntity.builder();
        archivedNewsEntity.id(src.getId());
        archivedNewsEntity.title(src.getTitle());
        archivedNewsEntity.creatorId(src.getCreatorId());
        archivedNewsEntity.newsType(src.getNewsType());
        archivedNewsEntity.content(src.getContent());
        List list = src.getTags();
        if (list != null) {
            archivedNewsEntity.tags(new ArrayList(list));
        }
        if ((list1 = src.getInstitutionalPages()) != null) {
            archivedNewsEntity.institutionalPages(new ArrayList(list1));
        }
        archivedNewsEntity.imageId(src.getImageId());
        archivedNewsEntity.imageUrl(src.getImageUrl());
        List list2 = src.getRegisteredAuthorIds();
        if (list2 != null) {
            archivedNewsEntity.registeredAuthorIds(new ArrayList(list2));
        }
        archivedNewsEntity.unRegisteredAuthors(this.authorEntityListToArchivedAuthorEntityList(src.getUnRegisteredAuthors()));
        archivedNewsEntity.creationTime(src.getCreationTime());
        archivedNewsEntity.updateTime(src.getUpdateTime());
        archivedNewsEntity.version(src.getVersion());
        ArchivedNewsEntity archivedNewsEntityResult = archivedNewsEntity.build();
        this.setUnregisteredAuthors(archivedNewsEntityResult);
        return archivedNewsEntityResult;
    }

    protected List<ArchivedAuthorEntity> authorEntityListToArchivedAuthorEntityList(List<AuthorEntity> list) {
        if (list == null) {
            return null;
        }
        ArrayList<ArchivedAuthorEntity> list1 = new ArrayList<ArchivedAuthorEntity>(list.size());
        for (AuthorEntity authorEntity : list) {
            list1.add(this.archivedAuthorMapper.toArchivedEntity(authorEntity));
        }
        return list1;
    }
}

