package com.finconsgroup.itserr.marketplace.news.bs.controller;

import com.finconsgroup.itserr.marketplace.core.web.dto.OutputPageDto;
import com.finconsgroup.itserr.marketplace.core.web.security.jwt.JwtTokenHolder;
import com.finconsgroup.itserr.marketplace.news.bs.api.NewsApi;
import com.finconsgroup.itserr.marketplace.news.bs.client.dto.newsDm.InputCreateNewsDto;
import com.finconsgroup.itserr.marketplace.news.bs.client.dto.newsDm.InputUpdateNewsDto;
import com.finconsgroup.itserr.marketplace.news.bs.dto.OutputNewsDetailDto;
import com.finconsgroup.itserr.marketplace.news.bs.service.NewsService;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.data.domain.Sort;
import org.springframework.web.bind.annotation.RestController;

import java.util.UUID;

/**
 * REST controller class for handling user news related API requests.
 *
 * <p>Implements the {@link NewsApi} interface.</p>
 */
@Slf4j
@RequiredArgsConstructor
@RestController
public class NewsController implements NewsApi {

    private final NewsService newsService;

    @Override
    public OutputPageDto<OutputNewsDetailDto> findAll(
            final int pageNumber,
            final int pageSize,
            final String sort,
            final Sort.Direction direction
    ) {
        return newsService.findAll(pageNumber, pageSize, sort, direction);
    }

    @Override
    public OutputNewsDetailDto findById(final UUID newsId) {
        return newsService.findById(newsId);
    }

    @Override
    public OutputNewsDetailDto createNews(final InputCreateNewsDto inputCreateNewsDto) {
        JwtTokenHolder.getUserIdOrThrow();
        return newsService.create(inputCreateNewsDto);
    }

    @Override
    public OutputNewsDetailDto updateNewsById(
            final UUID newsId,
            final InputUpdateNewsDto inputUpdateNewsDto
    ) {
        JwtTokenHolder.getUserIdOrThrow();
        return newsService.updateById(newsId, inputUpdateNewsDto);
    }

    @Override
    public void deleteNewsById(final UUID newsId) {
        JwtTokenHolder.getUserIdOrThrow();
        newsService.deleteById(newsId);
    }
}
