package com.finconsgroup.itserr.marketplace.news.bs.client.dto.newsDm;

import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.validation.constraints.NotBlank;
import jakarta.validation.constraints.NotNull;
import jakarta.validation.constraints.Size;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;

import java.util.UUID;

import static com.finconsgroup.itserr.marketplace.news.bs.util.ValidationConstants.VALIDATION_ERROR_FIELD_LENGTH;
import static com.finconsgroup.itserr.marketplace.news.bs.util.ValidationConstants.VALIDATION_ERROR_REQUIRED_FIELD;
import static com.finconsgroup.itserr.marketplace.news.bs.util.ValidationConstants.VALIDATION_URL_LENGTH;

/**
 * Input DTO for image.
 */
@Schema(name = "InputImageDto", description = "DTO for image")
@Data
@Builder
@AllArgsConstructor
public class InputImageDto {

    @Schema(description = "The document ID of the image", example = "123e4567-e89b-12d3-a456-426614174002")
    @NotNull(message = VALIDATION_ERROR_REQUIRED_FIELD)
    private UUID id;

    @Schema(description = "Public URL of the image", example = "https://example.com/images/tech-conference-2025.jpg")
    @NotBlank(message = VALIDATION_ERROR_REQUIRED_FIELD)
    @Size(max = VALIDATION_URL_LENGTH, message = VALIDATION_ERROR_FIELD_LENGTH)
    private String url;
}
