package com.finconsgroup.itserr.marketplace.metrics.feeder.dto.discussionbs;

import com.finconsgroup.itserr.messaging.dto.MessagingEventDto;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.NoArgsConstructor;
import lombok.ToString;
import lombok.experimental.SuperBuilder;

/**
 * Data transfer object representing a discussion thread creation event message.
 */
@Data
@EqualsAndHashCode(callSuper = true)
@SuperBuilder
@NoArgsConstructor
@ToString(callSuper = true)
public class DiscussionThreadCreatedMessageBodyDto
        extends MessagingEventDto<DiscussionThreadCreatedMessageBodyDto.AdditionalData> {

    /**
     * Additional data event.
     */
    @Data
    @Builder
    @NoArgsConstructor
    @AllArgsConstructor
    public static class AdditionalData {

        /** The unique identifier of the resource associated with the discussion thread. */
        private String discussionResourceId;

        /** The type of resource for which the discussion thread was created. */
        private String discussionResourceType;

    }

}
