package com.finconsgroup.itserr.marketplace.metrics.feeder;

import com.finconsgroup.itserr.marketplace.metrics.feeder.config.properties.MetricsFeederConfigurationProperties;
import io.swagger.v3.oas.annotations.OpenAPIDefinition;
import io.swagger.v3.oas.annotations.info.Info;
import org.springframework.boot.SpringApplication;
import org.springframework.boot.autoconfigure.SpringBootApplication;
import org.springframework.boot.context.properties.EnableConfigurationProperties;

@SpringBootApplication
@OpenAPIDefinition(info = @Info(
        title = "MetricsFeeder API",
        description = "API definition of the MetricsFeeder Microservice",
        version = "1.0.0"
))
@EnableConfigurationProperties({
        MetricsFeederConfigurationProperties.class,
})
public class MetricsFeederApplication {

    public static void main(String[] args) {
        SpringApplication.run(MetricsFeederApplication.class, args);
    }

}
