package com.finconsgroup.itserr.marketplace.metrics.feeder.dto.metricbs;

import com.fasterxml.jackson.annotation.JsonFormat;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.time.ZonedDateTime;
import java.util.UUID;

/**
 * Output DTO representing a metricEvent.
 */
@Data
@Builder
@NoArgsConstructor
@AllArgsConstructor
public class OutputMetricEventDto {

    /**
     * The unique identifier of this metric event.
     */
    private UUID id;

    /**
     * The type of metric being tracked, defined in {@link MetricDtoType}.
     */
    private MetricDtoType metric;

    /**
     * The identifier of the resource associated with this metric event.
     */
    private String resourceId;

    /**
     * The timestamp when the metric event occurred, including timezone information.
     */
    private ZonedDateTime eventTime;

    /**
     * The timestamp when this metric event was created in the system, formatted as ISO-8601.
     */
    @JsonFormat(shape = JsonFormat.Shape.STRING, pattern = "yyyy-MM-dd'T'HH:mm:ssXXX")
    private ZonedDateTime creationTime;

}
