package com.finconsgroup.itserr.marketplace.metrics.feeder.config.properties;

import jakarta.validation.Valid;
import jakarta.validation.constraints.NotNull;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;
import org.springframework.validation.annotation.Validated;

/**
 * Configuration properties class for messaging-related settings.
 */
@Validated
@Builder
@Data
@NoArgsConstructor
@AllArgsConstructor
public class MessagingConfigurationProperties {

    /**
     * Properties for favorite user messaging configuration. This field is required.
     */
    @NotNull
    @Valid
    private MessagingFavouriteUserBsProperties favouriteUser;

    /**
     * Properties for discussion messaging configuration. This field is required.
     */
    @NotNull
    @Valid
    private MessagingDiscussionBsProperties discussion;

}
