package com.finconsgroup.itserr.marketplace.metrics.feeder.client;

import com.finconsgroup.itserr.marketplace.metrics.feeder.dto.metricbs.InputCreateMetricEventDto;
import com.finconsgroup.itserr.marketplace.metrics.feeder.dto.metricbs.MetricDtoType;
import com.finconsgroup.itserr.marketplace.metrics.feeder.dto.metricbs.OutputMetricEventDto;
import jakarta.validation.Valid;
import org.springframework.http.MediaType;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;

/**
 * Client interface for interacting with the metrics-bs microservice.
 */
public interface MetricsBsClient {

    /**
     * Creates a new metric event.
     *
     * @param metric the metric type
     * @param event the input data transfer object containing metricEvent details
     * @return the created {@link OutputMetricEventDto} and HTTP status 201 (Created)
     */
    @PostMapping(
            value = "/metrics/metrics/{metricId}/events",
            consumes = MediaType.APPLICATION_JSON_VALUE,
            produces = MediaType.APPLICATION_JSON_VALUE
    )
    OutputMetricEventDto createMetricEvent(
            @PathVariable("metricId") MetricDtoType metric,
            @Valid @RequestBody InputCreateMetricEventDto event);

}
