/*
 * Decompiled with CFR 0.152.
 */
package com.finconsgroup.itserr.marketplace.metrics.dm.dto;

import com.finconsgroup.itserr.marketplace.metrics.dm.dto.InputBeneficiaryDto;
import com.finconsgroup.itserr.marketplace.metrics.dm.dto.InputCreateMetricEventDto;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.validation.constraints.NotBlank;
import jakarta.validation.constraints.NotNull;
import jakarta.validation.constraints.Size;
import java.time.ZonedDateTime;
import java.util.List;
import lombok.Generated;

@Schema(name="InputMetricEvent", description="DTO for creating a metricEvent")
public class InputCreateMetricEventDto {
    @Schema(description="The id of the resource the event refers to", example="123e4567-e89b-12d3-a456-426614174000")
    @NotBlank(message="required field")
    @Size(max=255, message="field length must be between {min} and {max}")
    private @NotBlank(message="required field") @Size(max=255, message="field length must be between {min} and {max}") String resourceId;
    @Schema(description="The author of the event", example="")
    @Size(max=255, message="field length must be between {min} and {max}")
    private @Size(max=255, message="field length must be between {min} and {max}") String eventAuthor;
    @Schema(description="The time of the event", example="2025-04-06T10:15:30+01:00")
    @NotNull(message="required field")
    private @NotNull(message="required field") ZonedDateTime eventTime;
    @Schema(description="The event beneficiaries (the users who will benefit from the event, increasing their counters and score)")
    private List<InputBeneficiaryDto> beneficiaries;

    @Generated
    public static InputCreateMetricEventDtoBuilder builder() {
        return new InputCreateMetricEventDtoBuilder();
    }

    @Generated
    public String getResourceId() {
        return this.resourceId;
    }

    @Generated
    public String getEventAuthor() {
        return this.eventAuthor;
    }

    @Generated
    public ZonedDateTime getEventTime() {
        return this.eventTime;
    }

    @Generated
    public List<InputBeneficiaryDto> getBeneficiaries() {
        return this.beneficiaries;
    }

    @Generated
    public void setResourceId(String resourceId) {
        this.resourceId = resourceId;
    }

    @Generated
    public void setEventAuthor(String eventAuthor) {
        this.eventAuthor = eventAuthor;
    }

    @Generated
    public void setEventTime(ZonedDateTime eventTime) {
        this.eventTime = eventTime;
    }

    @Generated
    public void setBeneficiaries(List<InputBeneficiaryDto> beneficiaries) {
        this.beneficiaries = beneficiaries;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof InputCreateMetricEventDto)) {
            return false;
        }
        InputCreateMetricEventDto other = (InputCreateMetricEventDto)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        String this$resourceId = this.getResourceId();
        String other$resourceId = other.getResourceId();
        if (this$resourceId == null ? other$resourceId != null : !this$resourceId.equals(other$resourceId)) {
            return false;
        }
        String this$eventAuthor = this.getEventAuthor();
        String other$eventAuthor = other.getEventAuthor();
        if (this$eventAuthor == null ? other$eventAuthor != null : !this$eventAuthor.equals(other$eventAuthor)) {
            return false;
        }
        ZonedDateTime this$eventTime = this.getEventTime();
        ZonedDateTime other$eventTime = other.getEventTime();
        if (this$eventTime == null ? other$eventTime != null : !((Object)this$eventTime).equals(other$eventTime)) {
            return false;
        }
        List this$beneficiaries = this.getBeneficiaries();
        List other$beneficiaries = other.getBeneficiaries();
        return !(this$beneficiaries == null ? other$beneficiaries != null : !((Object)this$beneficiaries).equals(other$beneficiaries));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof InputCreateMetricEventDto;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $resourceId = this.getResourceId();
        result = result * 59 + ($resourceId == null ? 43 : $resourceId.hashCode());
        String $eventAuthor = this.getEventAuthor();
        result = result * 59 + ($eventAuthor == null ? 43 : $eventAuthor.hashCode());
        ZonedDateTime $eventTime = this.getEventTime();
        result = result * 59 + ($eventTime == null ? 43 : ((Object)$eventTime).hashCode());
        List $beneficiaries = this.getBeneficiaries();
        result = result * 59 + ($beneficiaries == null ? 43 : ((Object)$beneficiaries).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "InputCreateMetricEventDto(resourceId=" + this.getResourceId() + ", eventAuthor=" + this.getEventAuthor() + ", eventTime=" + String.valueOf(this.getEventTime()) + ", beneficiaries=" + String.valueOf(this.getBeneficiaries()) + ")";
    }

    @Generated
    public InputCreateMetricEventDto(String resourceId, String eventAuthor, ZonedDateTime eventTime, List<InputBeneficiaryDto> beneficiaries) {
        this.resourceId = resourceId;
        this.eventAuthor = eventAuthor;
        this.eventTime = eventTime;
        this.beneficiaries = beneficiaries;
    }
}

