package com.finconsgroup.itserr.marketplace.metrics.bs.dto;

import io.swagger.v3.oas.annotations.media.Schema;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

/**
 * DTO representing minimal details from a catalog item response.
 */
@Schema(name = "OutputCatalogItemMinimalDto", description = "DTO representing minimal details from a catalog item response")
@Data
@Builder
@AllArgsConstructor
@NoArgsConstructor
public class OutputCatalogItemMinimalDto {

    @Schema(description = "Unique identifier of the catalog item", example = "3fa85f64-5717-4562-b3fc-2c963f66afa6")
    private String id;

    @Schema(description = "Title of the catalog item", example = "Sample Item")
    private String title;
}
