package com.finconsgroup.itserr.marketplace.metrics.bs.service;

import com.finconsgroup.itserr.marketplace.metrics.bs.bean.MetricsReportRequest;
import com.finconsgroup.itserr.marketplace.metrics.bs.dto.ExportFileFormat;
import org.springframework.core.io.InputStreamResource;
import org.springframework.lang.NonNull;

/**
 * Service interface for managing and retrieving metrics reports.
 */
public interface MetricReportService {

    /**
     * Download metrics report for the current user.
     *
     * @param format the export file format e.g. EXCEL
     * @param metricsReportRequest the data for generating metrics report
     * @return the {@link InputStreamResource} to download
     */
    InputStreamResource downloadReport(@NonNull ExportFileFormat format,
                                       @NonNull MetricsReportRequest metricsReportRequest);
}
