package com.finconsgroup.itserr.marketplace.metadata.dm.dto;

import io.swagger.v3.oas.annotations.media.Schema;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.time.Instant;
import java.util.List;
import java.util.UUID;

import com.finconsgroup.itserr.marketplace.metadata.dm.entity.enumerated.MetadataCategoryEnum;

/**
 * Metadata DTO.
 */
@Schema(
        name = "Metadata",
        description = "Represents a metadata"
)
@Data
@Builder
@NoArgsConstructor
@AllArgsConstructor
public class OutputMetadataDto {

    @Schema(
            description = "Metadata id",
            example = "f81d4fae-7dec-11d0-a765-00a0c91e6bf6")
    private UUID id;

    @Schema(
            description = "Metadata name",
            example = "Dublin Core (DC)")
    private String name;

    @Schema(
            description = "Metadata description",
            example = "Standard metadata for digital resources.")
    private String description;

    @Schema(description = "Metadata category")
    private MetadataCategoryEnum category;

    @Schema(description = "The ID of the creator", example = "f81d4fae-7dec-11d0-a765-00a0c91e6bf6")
    private UUID creatorId;

    @Schema(description = "Metadata fields")
    private List<OutputMetadataFieldDto> fields;

    @Schema(description = "Current status of the metadata", example = "DRAFT")
    private MetadataStatus status;

    @Schema(description = "Moderation message", example = "Metadata approved after review")
    private String moderationMessage;

    @Schema(description = "Creation timestamp", example = "2025-11-14T10:00:00Z")
    private Instant createdAt;

    @Schema(description = "Last update timestamp", example = "2025-11-14T10:00:00Z")
    private Instant updatedAt;

    @Schema(description = "User who last updated the metadata", example = "3fa85f64-5717-4562-b3fc-2c963f66afa6")
    private UUID updatedBy;
}
