/*
 * Decompiled with CFR 0.152.
 */
package com.finconsgroup.itserr.marketplace.metadata.dm.repository.specification;

import com.finconsgroup.itserr.marketplace.metadata.dm.dto.MetadataStatus;
import com.finconsgroup.itserr.marketplace.metadata.dm.entity.MetadataEntity;
import com.finconsgroup.itserr.marketplace.metadata.dm.entity.enumerated.MetadataCategoryEnum;
import jakarta.persistence.criteria.Expression;
import jakarta.persistence.criteria.Path;
import java.io.Serializable;
import java.util.Collection;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import org.springframework.data.jpa.domain.Specification;
import org.springframework.lang.NonNull;
import org.springframework.lang.Nullable;

/*
 * Exception performing whole class analysis ignored.
 */
public final class MetadataSpecifications {
    private MetadataSpecifications() {
        throw new UnsupportedOperationException("Cannot be instantiated");
    }

    @NonNull
    public static Specification<MetadataEntity> ids(@Nullable Collection<UUID> ids) {
        return (Specification & Serializable)(root, query, cb) -> MetadataSpecifications.sanitizeIds((Collection)ids).map(arg_0 -> ((Path)root.get("id")).in(arg_0)).orElse(cb.conjunction());
    }

    private static Optional<Set<UUID>> sanitizeIds(@Nullable Collection<UUID> ids) {
        if (ids == null) {
            return Optional.empty();
        }
        Set sanitizedIds = ids.stream().filter(Objects::nonNull).collect(Collectors.toSet());
        return sanitizedIds.isEmpty() ? Optional.empty() : Optional.of(sanitizedIds);
    }

    @NonNull
    public static Specification<MetadataEntity> hasCategory(MetadataCategoryEnum category) {
        return (Specification & Serializable)(root, query, cb) -> category == null ? cb.conjunction() : cb.equal((Expression)root.get("category"), (Object)category);
    }

    @NonNull
    public static Specification<MetadataEntity> hasStatusIn(Set<MetadataStatus> statuses) {
        return (Specification & Serializable)(root, query, cb) -> statuses == null || statuses.isEmpty() ? cb.conjunction() : root.get("status").in((Collection)statuses);
    }

    @NonNull
    public static Specification<MetadataEntity> hasStatusNotIn(Set<MetadataStatus> statuses) {
        return (Specification & Serializable)(root, query, cb) -> statuses == null || statuses.isEmpty() ? cb.conjunction() : cb.not((Expression)root.get("status").in((Collection)statuses));
    }

    @NonNull
    public static Specification<MetadataEntity> hasCreatorId(UUID creatorId) {
        return (Specification & Serializable)(root, query, cb) -> creatorId == null ? cb.conjunction() : cb.equal((Expression)root.get("creatorId"), (Object)creatorId);
    }

    @NonNull
    public static Specification<MetadataEntity> updatedBy(UUID updatedBy) {
        return (Specification & Serializable)(root, query, cb) -> updatedBy == null ? cb.conjunction() : cb.equal((Expression)root.get("updatedBy"), (Object)updatedBy);
    }

    @NonNull
    public static Specification<MetadataEntity> excludeCategory(MetadataCategoryEnum category) {
        return (Specification & Serializable)(root, query, cb) -> cb.notEqual((Expression)root.get("category"), (Object)category);
    }
}

