/*
 * Decompiled with CFR 0.152.
 */
package com.finconsgroup.itserr.marketplace.metadata.dm.authorization;

import com.finconsgroup.itserr.marketplace.core.web.exception.WP2AuthorizationException;
import com.finconsgroup.itserr.marketplace.core.web.security.jwt.JwtTokenHolder;
import com.finconsgroup.itserr.marketplace.metadata.dm.authorization.HasRoles;
import com.finconsgroup.itserr.marketplace.metadata.dm.config.SecurityConfig;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import lombok.Generated;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.annotation.Order;
import org.springframework.stereotype.Component;

@Aspect
@Component
@Order(value=1)
public class RolesAspect {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(RolesAspect.class);
    private final SecurityConfig securityConfig;

    @Around(value="@annotation(hasRoles)")
    public Object checkRoles(ProceedingJoinPoint pjp, HasRoles hasRoles) throws Throwable {
        UUID userId = JwtTokenHolder.getUserIdOrThrow();
        Set userRoles = JwtTokenHolder.getRoles((String)this.securityConfig.getAudience());
        Object[] requiredRoles = hasRoles.value();
        String methodName = pjp.getSignature().toShortString();
        log.debug("@HasRoles check on {}: user={}, requiredRoles={}", new Object[]{methodName, userId, Arrays.toString(requiredRoles)});
        boolean hasAllRoles = userRoles.containsAll(List.of(requiredRoles));
        if (!hasAllRoles) {
            log.warn("Authorization DENIED on {}: user={}, requiredRoles={}, userRoles={}", new Object[]{methodName, userId, Arrays.toString(requiredRoles), userRoles});
            throw new WP2AuthorizationException(String.format("User %s does not have the required roles: %s", userId, List.of(requiredRoles)));
        }
        log.debug("Authorization GRANTED on {}: user={}", (Object)methodName, (Object)userId);
        return pjp.proceed();
    }

    @Generated
    public RolesAspect(SecurityConfig securityConfig) {
        this.securityConfig = securityConfig;
    }
}

