package com.finconsgroup.itserr.marketplace.metadata.dm.authorization;

import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;

/**
 * Annotation to check if the current authenticated user has all the specified roles (AND logic).
 *
 * <p>The roles are extracted from the JWT token using the {@link com.finconsgroup.itserr.marketplace.core.web.security.jwt.JwtTokenHolder}
 * and matched against the roles specified in the annotation.</p>
 *
 * <p>Example usage:</p>
 * <pre>
 * {@code
 * @HasRoles({"Metadata-Editor", "Member"})
 * public OutputMetadataDto create(InputCreateMetadataDtoDto dto, UUID userId) {
 *     // User must have BOTH Metadata-Editor AND Member roles
 *     // If not, WP2AuthorizationException is thrown before method execution
 * }
 * }
 * </pre>
 *
 * <p>Single role example:</p>
 * <pre>
 * {@code
 * @HasRoles("Metadata-Moderator")
 * public void moderateMetadata(UUID metadataId) {
 *     // User must have Metadata-Moderator role
 * }
 * }
 * </pre>
 *
 * @see com.finconsgroup.itserr.marketplace.core.web.security.jwt.JwtTokenHolder
 */
@Target(ElementType.METHOD)
@Retention(RetentionPolicy.RUNTIME)
public @interface HasRoles {

    /**
     * The roles required to execute the method.
     * User must have ALL specified roles (AND logic).
     *
     * @return array of role names (e.g., {"Metadata-Editor", "Member"})
     */
    String[] value();
}
