/**
 * Global exception handler for REST controllers.
 */
package com.finconsgroup.itserr.marketplace.metadata.dm.exception;

import com.finconsgroup.itserr.marketplace.core.web.exception.ErrorResponseDto;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestControllerAdvice;
import org.springframework.web.context.request.WebRequest;

import static com.finconsgroup.itserr.marketplace.core.web.exception.ExceptionUtils.createResponseEntityError;
import static com.finconsgroup.itserr.marketplace.core.web.exception.ExceptionUtils.logError;

/**
 * Global exception handler.
 */
@RestControllerAdvice
public class CustomExceptionHandler {

    /**
     * <p>Handles a {@link MetadataExistsException}, which means that a name collision exists with an existing metadata.</p>
     * <p>A 409 Conflict is returned.</p>
     * @param ex Thrown exception.
     * @param request HTTP request.
     * @return Error response.
     */
    @ExceptionHandler(MetadataExistsException.class)
    @ResponseBody
    public ResponseEntity<ErrorResponseDto> handleCategoryNotFoundException(
            final MetadataExistsException ex,
            final WebRequest request) {
        logError(ex, request);
        return createResponseEntityError(HttpStatus.CONFLICT, ex.getMessage());
    }

}
