/*
 * Decompiled with CFR 0.152.
 */
package com.finconsgroup.itserr.marketplace.metadata.bs.messaging.impl;

import com.finconsgroup.itserr.marketplace.metadata.bs.config.MetadataBsConfigurationProperties;
import com.finconsgroup.itserr.marketplace.metadata.bs.dto.OutputMetadataDto;
import com.finconsgroup.itserr.marketplace.metadata.bs.messaging.ResourceProducer;
import com.finconsgroup.itserr.messaging.exception.WP2MessagingException;
import com.finconsgroup.itserr.messaging.producer.MessageProducer;
import com.finconsgroup.itserr.messaging.producer.ProducerRegistry;
import java.util.Map;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.lang.NonNull;
import org.springframework.stereotype.Component;

@Component
@ConditionalOnProperty(name={"messaging.enabled"}, havingValue="true")
public class DefaultResourceProducer
implements ResourceProducer {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(DefaultResourceProducer.class);
    private final MessageProducer messageProducer;
    private final MetadataBsConfigurationProperties.Messaging messagingProperties;

    public DefaultResourceProducer(MetadataBsConfigurationProperties metadataBsConfigurationProperties, ProducerRegistry producerRegistry) {
        this.messagingProperties = metadataBsConfigurationProperties.getMessaging();
        this.messageProducer = producerRegistry.getMessageProducer(this.messagingProperties.getProducerName());
    }

    public void publishApprovedResource(@NonNull OutputMetadataDto resource) {
        this.publish(resource, this.messagingProperties.getResourceCreatedType());
    }

    public void publishDeletedResource(@NonNull OutputMetadataDto resource) {
        this.publish(resource, this.messagingProperties.getResourceDeletedType());
    }

    private void publish(@NonNull OutputMetadataDto resource, @NonNull String eventType) {
        try {
            Map<String, OutputMetadataDto> messageMap = Map.of(resource.getId().toString(), resource);
            Map<String, String> filterProperties = Map.of("service", "metadata");
            log.debug("Sending message, messageMap: %s, eventType: %s, source: %s, filterProperties: %s".formatted(messageMap, eventType, this.messagingProperties.getSource(), filterProperties));
            this.messageProducer.publishEvent(messageMap, eventType, this.messagingProperties.getSource(), filterProperties);
            log.info("Successfully published message for resource with id: %s".formatted(resource.getId()));
        }
        catch (Exception e) {
            String errorMessage = "Error occurred while sending message: %s".formatted(e.getMessage());
            throw new WP2MessagingException(errorMessage, (Throwable)e);
        }
    }
}

