/*
 * Decompiled with CFR 0.152.
 */
package com.finconsgroup.itserr.marketplace.metadata.bs.component;

import com.finconsgroup.itserr.marketplace.core.web.security.jwt.JwtTokenHolder;
import com.finconsgroup.itserr.marketplace.metadata.bs.bean.MetadataEvent;
import com.finconsgroup.itserr.marketplace.metadata.bs.component.MessagingMetadataEventListener;
import com.finconsgroup.itserr.marketplace.metadata.bs.dto.OutputMetadataDto;
import com.finconsgroup.itserr.marketplace.metadata.bs.enums.EventType;
import com.finconsgroup.itserr.marketplace.metadata.bs.mapper.MetadataMapper;
import com.finconsgroup.itserr.marketplace.metadata.bs.messaging.EventProducer;
import com.finconsgroup.itserr.marketplace.metadata.bs.messaging.ResourceProducer;
import com.finconsgroup.itserr.marketplace.metadata.bs.messaging.dto.MetadataMessagingAdditionalDataDto;
import com.finconsgroup.itserr.marketplace.metadata.bs.messaging.dto.MetadataMessagingModerationRequestsAdditionalDataDto;
import com.finconsgroup.itserr.marketplace.metadata.bs.messaging.dto.MetadataMessagingStatusAdditionalDataDto;
import com.finconsgroup.itserr.marketplace.metadata.bs.service.UserProfileDetailProvider;
import com.finconsgroup.itserr.messaging.dto.MessagingEventDto;
import com.finconsgroup.itserr.messaging.dto.MessagingEventUserDto;
import java.util.LinkedList;
import java.util.Set;
import java.util.UUID;
import lombok.Generated;
import lombok.NonNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationListener;
import org.springframework.stereotype.Component;

@Component
public class MessagingMetadataEventListener
implements ApplicationListener<MetadataEvent> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(MessagingMetadataEventListener.class);
    private final EventProducer eventProducer;
    private final ResourceProducer resourceProducer;
    private final UserProfileDetailProvider userProfileDetailProvider;
    private final MetadataMapper metadataMapper;

    public MessagingMetadataEventListener(EventProducer eventProducer, ResourceProducer resourceProducer, UserProfileDetailProvider userProfileDetailProvider, MetadataMapper metadataMapper) {
        this.eventProducer = eventProducer;
        this.resourceProducer = resourceProducer;
        this.userProfileDetailProvider = userProfileDetailProvider;
        this.metadataMapper = metadataMapper;
    }

    public void onApplicationEvent(@NonNull MetadataEvent event) {
        if (event == null) {
            throw new NullPointerException("event is marked non-null but is null");
        }
        MessagingEventDto messagingEventDto = this.metadataMapper.toMessagingEventDto(event.getMetadata());
        MessagingEventUserDto user = MessagingEventUserDto.builder().id((UUID)JwtTokenHolder.getUserId().orElse(null)).name((String)JwtTokenHolder.getName().orElse(null)).username((String)JwtTokenHolder.getPreferredUsername().orElse(null)).build();
        messagingEventDto.setUser(user);
        this.updateEventForType(event, messagingEventDto);
        this.publishEventForType(event, messagingEventDto);
    }

    private void updateEventForType(MetadataEvent event, MessagingEventDto<MetadataMessagingAdditionalDataDto> eventDto) {
        OutputMetadataDto outputMetadataDto = event.getMetadata();
        MetadataMessagingAdditionalDataDto additionalData = this.createAdditionalData(event.getEventType());
        LinkedList<String> notifyUserIds = new LinkedList<String>();
        if (Set.of(EventType.CREATED, EventType.UPDATED).contains(event.getEventType())) {
            if (event.getEventType() == EventType.CREATED) {
                eventDto.setTimestamp(outputMetadataDto.getCreatedAt());
            } else {
                eventDto.setTimestamp(outputMetadataDto.getUpdatedAt());
            }
        } else if (Set.of(EventType.MODERATION_REQUESTED, EventType.DELETED).contains(event.getEventType())) {
            eventDto.setTimestamp(outputMetadataDto.getUpdatedAt());
            this.userProfileDetailProvider.getModeratorProfilesIds().stream().map(UUID::toString).forEach(notifyUserIds::add);
        } else if (Set.of(EventType.APPROVED, EventType.REJECTED).contains(event.getEventType())) {
            eventDto.setTimestamp(outputMetadataDto.getUpdatedAt());
            eventDto.setMessage(outputMetadataDto.getModerationMessage());
            notifyUserIds.add(outputMetadataDto.getCreator().getId().toString());
            if (additionalData instanceof MetadataMessagingStatusAdditionalDataDto) {
                MetadataMessagingStatusAdditionalDataDto statusAdditionalData = (MetadataMessagingStatusAdditionalDataDto)additionalData;
                statusAdditionalData.setContent(outputMetadataDto.getDescription());
                statusAdditionalData.setCreatorId(outputMetadataDto.getCreator().getId());
            }
        }
        additionalData.setNotifyUserIds(notifyUserIds);
        eventDto.setAdditionalData((Object)additionalData);
    }

    private MetadataMessagingAdditionalDataDto createAdditionalData(EventType eventType) {
        return switch (1.$SwitchMap$com$finconsgroup$itserr$marketplace$metadata$bs$enums$EventType[eventType.ordinal()]) {
            case 1, 2 -> new MetadataMessagingStatusAdditionalDataDto();
            case 3 -> new MetadataMessagingModerationRequestsAdditionalDataDto();
            default -> new MetadataMessagingAdditionalDataDto();
        };
    }

    private void publishEventForType(MetadataEvent event, MessagingEventDto<?> eventDto) {
        switch (1.$SwitchMap$com$finconsgroup$itserr$marketplace$metadata$bs$enums$EventType[event.getEventType().ordinal()]) {
            case 4: {
                this.eventProducer.publishCreateEvent(eventDto);
                break;
            }
            case 5: {
                this.eventProducer.publishUpdateEvent(eventDto);
                break;
            }
            case 3: {
                this.eventProducer.publishModerationRequested(eventDto);
                break;
            }
            case 6: {
                this.resourceProducer.publishDeletedResource(event.getMetadata());
                this.eventProducer.publishDeleteEvent(eventDto);
                break;
            }
            case 1: {
                this.resourceProducer.publishApprovedResource(event.getMetadata());
                this.eventProducer.publishStatusEvent(eventDto);
                break;
            }
            case 2: {
                this.eventProducer.publishStatusEvent(eventDto);
            }
        }
    }
}

