package com.finconsgroup.itserr.marketplace.metadata.bs.service.impl;

import com.finconsgroup.itserr.marketplace.core.web.dto.OutputPageDto;
import com.finconsgroup.itserr.marketplace.core.web.enums.SortDirection;
import com.finconsgroup.itserr.marketplace.metadata.bs.client.userprofile.UserProfileBsClient;
import com.finconsgroup.itserr.marketplace.metadata.bs.client.userprofile.UserProfileDmClient;
import com.finconsgroup.itserr.marketplace.metadata.bs.client.userprofile.dto.InputFindUserProfilesByIdsDto;
import com.finconsgroup.itserr.marketplace.metadata.bs.client.userprofile.dto.OutputUserProfileDmDto;
import com.finconsgroup.itserr.marketplace.metadata.bs.client.userprofile.dto.UserProfileBsOutputUserProfileDto;
import com.finconsgroup.itserr.marketplace.metadata.bs.dto.OutputUserProfileDto;
import com.finconsgroup.itserr.marketplace.metadata.bs.mapper.UserProfileMapper;
import com.finconsgroup.itserr.marketplace.metadata.bs.service.UserProfileDetailProvider;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.lang.NonNull;
import org.springframework.stereotype.Service;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;

/**
 * Default implementation of a {@link DefaultUserProfileDetailsProvider}.
 */
@Service
@Slf4j
@RequiredArgsConstructor
public class DefaultUserProfileDetailsProvider implements UserProfileDetailProvider {

    @Value("${metadata.bs.role-moderator}")
    private String roleModerator;

    private final UserProfileDmClient userProfileDmClient;
    private final UserProfileBsClient userProfileBsClient;
    private final UserProfileMapper userProfileMapper;

    public Map<UUID, OutputUserProfileDto> getUserDetailById(List<UUID> userProfileIds) {
        if (userProfileIds.isEmpty()) {
            return Map.of();
        }

        Map<UUID, OutputUserProfileDto> outputUserProfileDtoMap = new HashMap<>();
        try {
            InputFindUserProfilesByIdsDto inputFindUserProfilesByIdsDto = InputFindUserProfilesByIdsDto.builder()
                    .ids(new ArrayList<>(userProfileIds))
                    .build();
            OutputPageDto<OutputUserProfileDmDto> userOutputProfileDmPageDto = userProfileDmClient.findAllByIds(
                    inputFindUserProfilesByIdsDto, 0, userProfileIds.size(), "id", SortDirection.ASC);
            userOutputProfileDmPageDto.getContent().forEach(outputUserProfileDmDto ->
                    outputUserProfileDtoMap.put(outputUserProfileDmDto.getId(), userProfileMapper.userProfileDtoToCreatorDto(outputUserProfileDmDto)));
        } catch (Exception e) {
            log.error("Error loading user profiles", e);
        }
        return outputUserProfileDtoMap;
    }

    @NonNull
    public List<UUID> getModeratorProfilesIds() {
        try {
            return userProfileBsClient.getUserProfilesByRole(roleModerator)
                    .stream()
                    .map(UserProfileBsOutputUserProfileDto::getId)
                    .toList();
        } catch (Exception e) {
            log.error("Error loading user profiles by role", e);
        }
        return List.of();
    }
}
