package com.finconsgroup.itserr.marketplace.metadata.bs.enums;

/**
 * Enumeration representing resource lifecycle events for debugging and analysis purposes.
 * <p>
 * <b>Note:</b> This enum is intended solely for diagnostic use and should not be used
 * in production business logic.
 *
 * <p>Supported event types:</p>
 * <ul>
 *   <li>{@code CREATED} - Indicates a new resource was created</li>
 *   <li>{@code DELETED} - Indicates a resource was removed</li>
 * </ul>
 *
 * @see com.finconsgroup.itserr.marketplace.metadata.bs.controller.DiagnosticsController#publishMessage(EventType, String)
 * @since 1.0
 */
public enum EventType {
    CREATED,
    UPDATED,
    DELETED,
    MODERATION_REQUESTED,
    APPROVED,
    REJECTED;
}
