package com.finconsgroup.itserr.marketplace.metadata.bs.dto;

import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.validation.constraints.NotBlank;
import jakarta.validation.constraints.NotEmpty;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.time.Instant;
import java.util.List;
import java.util.UUID;

/**
 * Metadata DTO.
 */
@Schema(
        name = "Metadata",
        description = "Represents a metadata"
)
@Data
@Builder
@NoArgsConstructor
@AllArgsConstructor
public class OutputMetadataDto {

    @Schema(
            description = "Metadata id",
            example = "f81d4fae-7dec-11d0-a765-00a0c91e6bf6")
    @NotBlank
    private UUID id;

    @Schema(
            description = "Metadata name",
            example = "Dublin Core (DC)")
    @NotBlank
    private String name;

    @Schema(
            description = "Metadata description",
            example = "Standard metadata for digital resources.")
    private String description;

    @Schema(description = "Metadata category")
    private MetadataCategoryEnum category;

    @Schema(description = "Metadata creator")
    private OutputUserProfileDto creator;

    @Schema(description = "Metadata fields")
    @NotEmpty
    private List<OutputMetadataFieldDto> fields;

    @Schema(description = "Current status of the metadata", example = "DRAFT")
    private MetadataStatus status;

    @Schema(description = "Moderation message", example = "Metadata approved after review")
    private String moderationMessage;

    @Schema(description = "Creation timestamp", example = "2025-11-14T10:00:00Z")
    private Instant createdAt;

    @Schema(description = "Last update timestamp", example = "2025-11-14T10:00:00Z")
    private Instant updatedAt;

    @Schema(description = "User who last updated the metadata")
    private OutputUserProfileDto updatedBy;
}
