package com.finconsgroup.itserr.marketplace.metadata.bs.service.impl;

import com.finconsgroup.itserr.marketplace.core.web.dto.OutputPageDto;
import com.finconsgroup.itserr.marketplace.core.web.exception.WP2AuthorizationException;
import com.finconsgroup.itserr.marketplace.metadata.bs.client.metadatadm.MetadataModerationDmClient;
import com.finconsgroup.itserr.marketplace.metadata.bs.client.metadatadm.dto.InputModerationStatusDmDto;
import com.finconsgroup.itserr.marketplace.metadata.bs.client.metadatadm.dto.ModerationDmStatus;
import com.finconsgroup.itserr.marketplace.metadata.bs.client.metadatadm.dto.OutputMetadataDmDto;
import com.finconsgroup.itserr.marketplace.metadata.bs.dto.InputModerationStatusDto;
import com.finconsgroup.itserr.marketplace.metadata.bs.dto.ModerationStatus;
import com.finconsgroup.itserr.marketplace.metadata.bs.dto.OutputUserProfileDto;
import com.finconsgroup.itserr.marketplace.metadata.bs.dto.OutputMetadataDto;
import com.finconsgroup.itserr.marketplace.metadata.bs.mapper.MetadataMapper;
import com.finconsgroup.itserr.marketplace.metadata.bs.service.MetadataModerationService;
import feign.FeignException;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.data.domain.Sort;
import org.springframework.stereotype.Service;

import java.util.List;
import java.util.Map;
import java.util.UUID;

/**
 * Default implementation of DefaultMetadataModerationService.
 */
@Service
@RequiredArgsConstructor
@Slf4j
public class DefaultMetadataModerationService implements MetadataModerationService {

    private final MetadataModerationDmClient metadataModerationDmClient;
    private final MetadataMapper metadataMapper;
    private final UserProfileHelper userProfileHelper;

    @Override
    public OutputPageDto<OutputMetadataDto> getMetadataListForModeration(ModerationStatus status, int pageNumber, int pageSize, String sort, Sort.Direction direction) {
        ModerationDmStatus moderationDmStatus = (status != null) ? ModerationDmStatus.fromString(status.getValue()) : null;

        OutputPageDto<OutputMetadataDmDto> outputMetadataDmDtoOutputPageDto = metadataModerationDmClient
                .getMetadataListForModeration(moderationDmStatus, pageNumber, pageSize, sort, direction);

        Map<UUID, OutputUserProfileDto> userDetails = userProfileHelper.fetchUserDetails(outputMetadataDmDtoOutputPageDto.getContent());

        List<OutputMetadataDto> outputMetadataDtoList = outputMetadataDmDtoOutputPageDto.getContent().stream()
                .map(dto -> {
                    OutputMetadataDto outputMetadataDto = metadataMapper.clientDtoToDto(dto);
                    userProfileHelper.enrichMetadataDto(dto, outputMetadataDto, userDetails);
                    return outputMetadataDto;
                })
                .toList();

        OutputPageDto<OutputMetadataDto> outputMetadataDtoOutputPageDto = OutputPageDto.emptyWithPage(outputMetadataDmDtoOutputPageDto.getPage());
        outputMetadataDtoOutputPageDto.setContent(outputMetadataDtoList);
        return outputMetadataDtoOutputPageDto;
    }

    @Override
    public OutputMetadataDto getMetadataForModeration(UUID metadataId) {
        OutputMetadataDmDto outputMetadataDmDto = metadataModerationDmClient.getMetadataForModeration(metadataId);
        Map<UUID, OutputUserProfileDto> userDetails = userProfileHelper.fetchUserDetails(List.of(outputMetadataDmDto));
        OutputMetadataDto outputMetadataDto = metadataMapper.clientDtoToDto(outputMetadataDmDto);
        userProfileHelper.enrichMetadataDto(outputMetadataDmDto, outputMetadataDto, userDetails);
        return outputMetadataDto;    }

    @Override
    public OutputMetadataDto setModerationStatus(UUID metadataId, InputModerationStatusDto inputModerationStatusDto) {
        InputModerationStatusDmDto dto = metadataMapper.dtoToClientDto(inputModerationStatusDto);
        try {
            OutputMetadataDmDto outputMetadataDmDto = metadataModerationDmClient.setModerationStatus(metadataId, dto);
            Map<UUID, OutputUserProfileDto> userDetails = userProfileHelper.fetchUserDetails(List.of(outputMetadataDmDto));
            OutputMetadataDto outputMetadataDto = metadataMapper.clientDtoToDto(outputMetadataDmDto);
            userProfileHelper.enrichMetadataDto(outputMetadataDmDto, outputMetadataDto, userDetails);
            return outputMetadataDto;
        } catch (final FeignException.Forbidden e) {
            throw new WP2AuthorizationException(e.contentUTF8());
        }
    }
}
