package com.finconsgroup.itserr.marketplace.metadata.bs.client.metadatadm.dto;

import io.swagger.v3.oas.annotations.media.Schema;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.util.UUID;

/**
 * Metadata Preview DTO.
 */
@Schema(
        name = "Metadata preview",
        description = "Represents a metadata preview"
)
@Data
@Builder
@NoArgsConstructor
@AllArgsConstructor
public class OutputMetadataPreviewDmDto {

    @Schema(
            description = "Metadata id",
            example = "f81d4fae-7dec-11d0-a765-00a0c91e6bf6")
    private UUID id;

    @Schema(
            description = "Metadata name",
            example = "Dublin Core (DC)")
    private String name;

    @Schema(
            description = "Metadata description",
            example = "Standard metadata for digital resources.")
    private String description;

    @Schema(description = "Metadata category")
    private MetadataCategoryDmEnum category;

    @Schema(description = "The ID of the creator", example = "f81d4fae-7dec-11d0-a765-00a0c91e6bf6")
    private UUID creatorId;

    @Schema(description = "Current status of the metadata", example = "DRAFT")
    private MetadataDmStatus status;
}
