/*
 * Decompiled with CFR 0.152.
 */
package com.finconsgroup.itserr.marketplace.metadata.bs.service.impl;

import com.finconsgroup.itserr.marketplace.core.web.dto.OutputPageDto;
import com.finconsgroup.itserr.marketplace.core.web.exception.WP2AuthorizationException;
import com.finconsgroup.itserr.marketplace.metadata.bs.client.metadatadm.MetadataModerationDmClient;
import com.finconsgroup.itserr.marketplace.metadata.bs.client.metadatadm.dto.InputModerationStatusDmDto;
import com.finconsgroup.itserr.marketplace.metadata.bs.client.metadatadm.dto.ModerationDmStatus;
import com.finconsgroup.itserr.marketplace.metadata.bs.client.metadatadm.dto.OutputMetadataDmDto;
import com.finconsgroup.itserr.marketplace.metadata.bs.dto.InputModerationStatusDto;
import com.finconsgroup.itserr.marketplace.metadata.bs.dto.ModerationStatus;
import com.finconsgroup.itserr.marketplace.metadata.bs.dto.OutputMetadataDto;
import com.finconsgroup.itserr.marketplace.metadata.bs.mapper.MetadataMapper;
import com.finconsgroup.itserr.marketplace.metadata.bs.service.MetadataModerationService;
import com.finconsgroup.itserr.marketplace.metadata.bs.service.impl.UserProfileHelper;
import feign.FeignException;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.domain.Sort;
import org.springframework.stereotype.Service;

@Service
public class DefaultMetadataModerationService
implements MetadataModerationService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(DefaultMetadataModerationService.class);
    private final MetadataModerationDmClient metadataModerationDmClient;
    private final MetadataMapper metadataMapper;
    private final UserProfileHelper userProfileHelper;

    public OutputPageDto<OutputMetadataDto> getMetadataListForModeration(ModerationStatus status, int pageNumber, int pageSize, String sort, Sort.Direction direction) {
        ModerationDmStatus moderationDmStatus = status != null ? ModerationDmStatus.fromString((String)status.getValue()) : null;
        OutputPageDto outputMetadataDmDtoOutputPageDto = this.metadataModerationDmClient.getMetadataListForModeration(moderationDmStatus, pageNumber, pageSize, sort, direction);
        Map userDetails = this.userProfileHelper.fetchUserDetails(outputMetadataDmDtoOutputPageDto.getContent());
        List<OutputMetadataDto> outputMetadataDtoList = outputMetadataDmDtoOutputPageDto.getContent().stream().map(dto -> {
            OutputMetadataDto outputMetadataDto = this.metadataMapper.clientDtoToDto(dto);
            this.userProfileHelper.enrichMetadataDto(dto, outputMetadataDto, userDetails);
            return outputMetadataDto;
        }).toList();
        OutputPageDto outputMetadataDtoOutputPageDto = OutputPageDto.emptyWithPage((OutputPageDto.Page)outputMetadataDmDtoOutputPageDto.getPage());
        outputMetadataDtoOutputPageDto.setContent(outputMetadataDtoList);
        return outputMetadataDtoOutputPageDto;
    }

    public OutputMetadataDto getMetadataForModeration(UUID metadataId) {
        OutputMetadataDmDto outputMetadataDmDto = this.metadataModerationDmClient.getMetadataForModeration(metadataId);
        Map userDetails = this.userProfileHelper.fetchUserDetails(List.of(outputMetadataDmDto));
        OutputMetadataDto outputMetadataDto = this.metadataMapper.clientDtoToDto(outputMetadataDmDto);
        this.userProfileHelper.enrichMetadataDto(outputMetadataDmDto, outputMetadataDto, userDetails);
        return outputMetadataDto;
    }

    public OutputMetadataDto setModerationStatus(UUID metadataId, InputModerationStatusDto inputModerationStatusDto) {
        InputModerationStatusDmDto dto = this.metadataMapper.dtoToClientDto(inputModerationStatusDto);
        try {
            OutputMetadataDmDto outputMetadataDmDto = this.metadataModerationDmClient.setModerationStatus(metadataId, dto);
            Map userDetails = this.userProfileHelper.fetchUserDetails(List.of(outputMetadataDmDto));
            OutputMetadataDto outputMetadataDto = this.metadataMapper.clientDtoToDto(outputMetadataDmDto);
            this.userProfileHelper.enrichMetadataDto(outputMetadataDmDto, outputMetadataDto, userDetails);
            return outputMetadataDto;
        }
        catch (FeignException.Forbidden e) {
            throw new WP2AuthorizationException(e.contentUTF8());
        }
    }

    @Generated
    public DefaultMetadataModerationService(MetadataModerationDmClient metadataModerationDmClient, MetadataMapper metadataMapper, UserProfileHelper userProfileHelper) {
        this.metadataModerationDmClient = metadataModerationDmClient;
        this.metadataMapper = metadataMapper;
        this.userProfileHelper = userProfileHelper;
    }
}

