package com.finconsgroup.itserr.marketplace.metadata.bs.client.metadatadm.dto;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import io.swagger.v3.oas.annotations.media.Schema;

@Schema(description = "Moderation result enumeration")
public enum ModerationDmResult {
    APPROVED("approved"),
    REJECTED("rejected");

    private final String value;

    ModerationDmResult(String value) {
        this.value = value;
    }

    @JsonValue
    public String getValue() {
        return value;
    }

    @Override
    public String toString() {
        return value;
    }

    @JsonCreator
    public static ModerationDmResult fromString(String value) {
        if (value == null) {
            return null;
        }
        for (ModerationDmResult status : ModerationDmResult.values()) {
            if (status.value.equalsIgnoreCase(value)) {
                return status;
            }
        }
        throw new IllegalArgumentException("Unknown ModerationDmResult: " + value);
    }
}