package com.finconsgroup.itserr.marketplace.metadata.bs.messaging.dto;

import com.finconsgroup.itserr.marketplace.metadata.bs.enums.MetadataCategoryEnum;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;
import lombok.experimental.SuperBuilder;

import java.util.List;
import java.util.UUID;

/**
 * Metadata created message body.
 */
@Data
@SuperBuilder
@NoArgsConstructor
@AllArgsConstructor
public class MetadataCreatedMessageBodyDto extends MessageBodyDto {

    /**
     * Metadata name.
     */
    private String name;

    /**
     * Metadata description.
     */
    private String description;

    private MetadataCategoryEnum category;

    private UUID creatorId;

    /**
     * Metadata fields.
     */
    private List<Field> fields;

    /**
     * Created metadata field message.
     *
     * @param name        Field name
     * @param description Description
     * @param type        Type of the field expected value
     * @param vocabulary  List of terms that are allowed as values, or null/empty for any available. This should be alternative to 'validation'.
     * @param validation  A regex that the value should comply with. This should be alternative to 'vocabulary'.
     * @param mandatory   true if the metadata value is mandatory, false otherwise
     */
    @Builder
    public record Field(
            String name,
            String description,
            FieldType type,
            List<String> vocabulary,
            String validation,
            boolean mandatory) {
    }

    /**
     * Metadata field value type enumeration.
     */
    public enum FieldType {
        STRING,
        TIME,
        TIME_INTERVAL,
        TIMES_LISTOF,
        TEXT,
        BOOLEAN,
        NUMBER,
        GEO_JSON
    }
}
