create schema if not exists "wp2_label";

set schema 'wp2_label';

-- drop table if exists "label";
create table if not exists "label"
(
    id                 uuid primary key,
    name               varchar(100)                not null check (name <> ''),
    context            varchar(100)                not null check (context <> ''),
    creation_timestamp timestamp without time zone not null DEFAULT current_timestamp
);

-- drop index if exists label_context_name_uidx;
create unique index if not exists label_context_name_uidx ON label(upper(context), upper(name));
