/*
 * Decompiled with CFR 0.152.
 */
package com.finconsgroup.itserr.marketplace.institutionalpage.dm.util;

import jakarta.persistence.Column;
import jakarta.persistence.JoinColumn;
import java.lang.reflect.Field;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicReference;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.lang.NonNull;

/*
 * Exception performing whole class analysis ignored.
 */
public class SpringDataUtils {
    private static final Map<String, String> COLUMN_NAME_BY_ENTITY_FIELD = new ConcurrentHashMap();

    private SpringDataUtils() {
        throw new UnsupportedOperationException("JpaUtils cannot be instantiated");
    }

    public static Pageable mapSortToColumnName(Pageable pageable, Class<?> entityClass, boolean failNonColumns) {
        if (pageable.getSort().isUnsorted()) {
            return pageable;
        }
        Sort sort = SpringDataUtils.mapSortToColumnName(entityClass, (Sort)pageable.getSort(), (boolean)failNonColumns);
        Object mappedPageable = pageable.isUnpaged() ? Pageable.unpaged((Sort)sort) : PageRequest.of((int)pageable.getPageNumber(), (int)pageable.getPageSize(), (Sort)sort);
        return mappedPageable;
    }

    private static String getColumnName(Class<?> entityClass, String fieldName, boolean failNonColumns) {
        String key = "%s_%s".formatted(entityClass.getName(), fieldName);
        String columnName = (String)COLUMN_NAME_BY_ENTITY_FIELD.get(key);
        if (columnName != null) {
            return columnName;
        }
        try {
            Field field = SpringDataUtils.getDeclaredField(entityClass, (String)fieldName);
            Column columnAnnotation = field.getAnnotation(Column.class);
            JoinColumn joinColumnAnnotation = field.getAnnotation(JoinColumn.class);
            if (columnAnnotation != null && !columnAnnotation.name().isBlank()) {
                columnName = columnAnnotation.name();
            } else if (joinColumnAnnotation != null && !joinColumnAnnotation.name().isBlank()) {
                columnName = joinColumnAnnotation.name();
            } else {
                if (failNonColumns) {
                    throw new IllegalArgumentException("Field '" + fieldName + "' does not have supported annotation in " + entityClass.getSimpleName());
                }
                columnName = field.getName();
            }
            if (failNonColumns) {
                COLUMN_NAME_BY_ENTITY_FIELD.put(key, columnName);
            }
            return columnName;
        }
        catch (NoSuchFieldException e) {
            throw new IllegalArgumentException("Field '" + fieldName + "' not found in " + entityClass.getSimpleName(), e);
        }
    }

    @NonNull
    private static Sort mapSortToColumnName(@NonNull Class<?> entityClass, @NonNull Sort sort, boolean failNonColumns) {
        AtomicReference<Sort> sortResult = new AtomicReference<Sort>(Sort.unsorted());
        for (Sort.Order order : sort) {
            Sort newSort = Sort.by((Sort.Direction)order.getDirection(), (String[])new String[]{SpringDataUtils.getColumnName(entityClass, (String)order.getProperty(), (boolean)failNonColumns)});
            sortResult.getAndAccumulate(newSort, Sort::and);
        }
        return sortResult.get();
    }

    @NonNull
    private static Field getDeclaredField(@NonNull Class<?> clazz, @NonNull String fieldName) throws NoSuchFieldException {
        for (Class<?> current = clazz; current != null; current = current.getSuperclass()) {
            try {
                return current.getDeclaredField(fieldName);
            }
            catch (NoSuchFieldException e) {
                continue;
            }
        }
        throw new NoSuchFieldException("Field '" + fieldName + "' not found in class hierarchy for " + clazz.getSimpleName());
    }
}

