package com.finconsgroup.itserr.marketplace.institutionalpage.dm.dto;

import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.validation.constraints.NotNull;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;

import static com.finconsgroup.itserr.marketplace.institutionalpage.dm.util.Constants.VALIDATION_ERROR_REQUIRED_FIELD;

/**
 * Input DTO to approve or reject a pending Institutional Page.
 */
@Schema(name = "InputPatchIPModerationRequestDto", description = "Input DTO to approve or reject a pending Institutional Page")
@Data
@Builder
@AllArgsConstructor
// TODO currently not mandatory from FE - @ValidInputDto
public class InputPatchIPModerationRequestDto {

    @Schema(
            description = "Specify whether to approve or reject the pending institutional page",
            example = "true"
    )
    @NotNull(message = VALIDATION_ERROR_REQUIRED_FIELD)
    private Boolean approved;

    @Schema(
            description = "The rejection message",
            example = "The copyright is not compatible with our standard"
    )
    private String message;

}
