create schema if not exists "wp2_institutional_page";
set schema 'wp2_institutional_page';

--liquibase formatted sql

--changeset antonio.amendola:20250702110511 labels:feature context:v1.0
--comment: add table institutional_page
create table if not exists "institutional_page" (
  id uuid primary key,
  name varchar(255) not null,
  parent_institutional_page_id uuid references "institutional_page"(id),
  ancestor_institutional_page_ids uuid[],
  workspace_folder_id uuid not null,
  category varchar(255) not null,
  published boolean not null,
  to_delete boolean not null,
  moderation_status varchar(255) not null,
  publication_time timestamptz(6),
  rejection_message varchar(255),
  original_institutional_page_id uuid,
  updated_institutional_page_id uuid,
  abstract_content text not null,
  copyright_text varchar(255) not null,
  copyright_year integer not null,
  maintainer uuid,
  tags varchar(255)[],
  languages varchar(255)[],
  image_url varchar(255),
  user_manual_url varchar(255),
  faqs_url varchar(255),
  application_version varchar(255),
  application_type varchar(255),
  license varchar(255),
  supported_os varchar(800),
  repo_name varchar(255),
  website varchar(255),
  additional_fields jsonb,
  external_links jsonb,
  buttons jsonb,
  update_locked_by uuid,
  last_modified_by uuid not null,
  creation_time timestamptz(6) not null,
  update_time timestamptz(6) not null,
  version bigint not null default 0
);
--rollback drop table if exists "institutional_page";

--changeset antonio.amendola:20250702110623 labels:feature context:v1.0
--comment: add table institutional_page_member
create table if not exists "institutional_page_member" (
  id uuid primary key,
  institutional_page_id uuid not null references "institutional_page"(id),
  member_id uuid not null,
  wp_lead boolean not null,
  creation_time timestamptz(6) not null,
  update_time timestamptz(6) not null,
  version bigint not null default 0,
  member_order bigint,
  constraint uq_ip_member unique (institutional_page_id, member_id)
);
--rollback drop table if exists "institutional_page_member";

--changeset antonio.amendola:20250702110629 labels:feature context:v1.0
--comment: add table paragraph
create table if not exists "paragraph" (
  id uuid primary key,
  institutional_page_id uuid not null references "institutional_page"(id),
  title varchar(255) not null,
  content text,
  image_url varchar(255),
  resource_url varchar(255),
  labels varchar(255)[],
  creation_time timestamptz(6) not null,
  update_time timestamptz(6) not null,
  version bigint not null default 0,
  paragraph_order bigint
);
--rollback drop table if exists "paragraph";

--changeset antonio.amendola:20250710124752 labels:feature context:v1.0
--comment: add table member_request
create table if not exists "member_request" (
  id uuid primary key,
  user_id uuid not null,
  institutional_page_id uuid not null references "institutional_page"(id),
  request_type varchar(255) not null,
  wp_leader boolean not null,
  message varchar(255),
  creation_time timestamptz(6) not null,
  update_time timestamptz(6) not null,
  version bigint not null default 0,
  member_request_order bigint,
  constraint uq_member_request unique (institutional_page_id, user_id, request_type)
);
--rollback drop table if exists "member_request";

--changeset antonio.amendola:20250702110643 labels:feature context:v1.0
--comment: add table archived_institutional_page
create table if not exists "archived_institutional_page" (
  id uuid primary key,
  name varchar(255) not null,
  parent_institutional_page_id uuid,
  ancestor_institutional_page_ids uuid[],
  workspace_folder_id uuid not null,
  category varchar(255) not null,
  published boolean not null,
  to_delete boolean not null,
  moderation_status varchar(255) not null,
  publication_time timestamptz(6),
  rejection_message varchar(255),
  original_institutional_page_id uuid,
  updated_institutional_page_id uuid,
  abstract_content text not null,
  copyright_text varchar(255) not null,
  copyright_year integer not null,
  maintainer uuid,
  tags varchar(255)[],
  languages varchar(255)[],
  image_url varchar(255),
  user_manual_url varchar(255),
  faqs_url varchar(255),
  application_version varchar(255),
  application_type varchar(255),
  license varchar(255),
  supported_os varchar(800),
  repo_name varchar(255),
  website varchar(255),
  additional_fields jsonb,
  external_links jsonb,
  buttons jsonb,
  update_locked_by uuid,
  last_modified_by uuid not null,
  creation_time timestamptz(6) not null,
  update_time timestamptz(6) not null,
  archival_time timestamptz(6) not null
);
--rollback drop table if exists "archived_institutional_page";

--changeset antonio.amendola:20250702110654 labels:feature context:v1.0
--comment: add table archived_institutional_page_member
create table if not exists "archived_institutional_page_member" (
  id uuid primary key,
  institutional_page_id uuid not null,
  member_id uuid not null,
  wp_lead boolean not null,
  creation_time timestamptz(6) not null,
  update_time timestamptz(6) not null,
  archival_time timestamptz(6) not null,
  member_order bigint
);
--rollback drop table if exists "archived_institutional_page_member";

--changeset antonio.amendola:20250702110701 labels:feature context:v1.0
--comment: add table archived_paragraph
create table if not exists "archived_paragraph" (
  id uuid primary key,
  institutional_page_id uuid not null,
  title varchar(255) not null,
  content text,
  image_url varchar(255),
  resource_url varchar(255),
  labels varchar(255)[],
  creation_time timestamptz(6) not null,
  update_time timestamptz(6) not null,
  archival_time timestamptz(6) not null,
  paragraph_order bigint
);
--rollback drop table if exists "archived_paragraph";

--changeset antonio.amendola:20250717185847 labels:feature context:v1.0
--comment: add table archived_member_request
create table if not exists "archived_member_request" (
  id uuid primary key,
  user_id uuid not null,
  institutional_page_id uuid not null,
  request_type varchar(255) not null,
  wp_leader boolean not null,
  request_status varchar(255) not null,
  message varchar(255),
  creation_time timestamptz(6) not null,
  update_time timestamptz(6) not null,
  member_request_order bigint,
  archival_time timestamptz(6) not null
);
--rollback drop table if exists "archived_member_request";
