/*
 * Decompiled with CFR 0.152.
 */
package com.finconsgroup.itserr.marketplace.institutionalpage.dm.entity;

import com.finconsgroup.itserr.marketplace.core.entity.AbstractUUIDEntity;
import com.finconsgroup.itserr.marketplace.institutionalpage.dm.entity.InstitutionalPageEntity;
import com.finconsgroup.itserr.marketplace.institutionalpage.dm.entity.ParagraphEntity;
import jakarta.persistence.Column;
import jakarta.persistence.Entity;
import jakarta.persistence.FetchType;
import jakarta.persistence.JoinColumn;
import jakarta.persistence.ManyToOne;
import jakarta.persistence.PostPersist;
import jakarta.persistence.PreUpdate;
import jakarta.persistence.Table;
import jakarta.persistence.Version;
import java.time.Instant;
import java.time.temporal.ChronoUnit;
import java.util.List;
import java.util.UUID;
import lombok.Generated;

@Entity
@Table(name="paragraph")
public class ParagraphEntity
extends AbstractUUIDEntity {
    @ManyToOne(fetch=FetchType.LAZY, optional=false)
    @JoinColumn(name="institutional_page_id", updatable=false)
    private InstitutionalPageEntity institutionalPage;
    @Column(name="institutional_page_id", insertable=false, updatable=false)
    private UUID institutionalPageId;
    @Column(name="title", nullable=false)
    private String title;
    @Column(name="content", length=8000)
    private String content;
    @Column(name="image_url")
    private String imageUrl;
    @Column(name="resource_url")
    private String resourceUrl;
    @Column(name="labels")
    private List<String> labels;
    @Column(name="creation_time", nullable=false, updatable=false)
    private Instant creationTime;
    @Column(name="update_time", nullable=false)
    private Instant updateTime;
    @Version
    private long version;

    public void prePersist() {
        super.prePersist();
        Instant currentTime = Instant.now().truncatedTo(ChronoUnit.MICROS);
        if (this.creationTime == null) {
            this.creationTime = currentTime;
        }
        this.updateTime = currentTime;
    }

    @PostPersist
    public void postPersist() {
        this.institutionalPageId = this.institutionalPage.getId();
    }

    @PreUpdate
    public void onUpdate() {
        this.updateTime = Instant.now().truncatedTo(ChronoUnit.MICROS);
    }

    @Generated
    protected ParagraphEntity(ParagraphEntityBuilder<?, ?> b) {
        super(b);
        this.institutionalPage = b.institutionalPage;
        this.institutionalPageId = b.institutionalPageId;
        this.title = b.title;
        this.content = b.content;
        this.imageUrl = b.imageUrl;
        this.resourceUrl = b.resourceUrl;
        this.labels = b.labels;
        this.creationTime = b.creationTime;
        this.updateTime = b.updateTime;
        this.version = b.version;
    }

    @Generated
    public static ParagraphEntityBuilder<?, ?> builder() {
        return new ParagraphEntityBuilderImpl();
    }

    @Generated
    public InstitutionalPageEntity getInstitutionalPage() {
        return this.institutionalPage;
    }

    @Generated
    public UUID getInstitutionalPageId() {
        return this.institutionalPageId;
    }

    @Generated
    public String getTitle() {
        return this.title;
    }

    @Generated
    public String getContent() {
        return this.content;
    }

    @Generated
    public String getImageUrl() {
        return this.imageUrl;
    }

    @Generated
    public String getResourceUrl() {
        return this.resourceUrl;
    }

    @Generated
    public List<String> getLabels() {
        return this.labels;
    }

    @Generated
    public Instant getCreationTime() {
        return this.creationTime;
    }

    @Generated
    public Instant getUpdateTime() {
        return this.updateTime;
    }

    @Generated
    public long getVersion() {
        return this.version;
    }

    @Generated
    public void setInstitutionalPage(InstitutionalPageEntity institutionalPage) {
        this.institutionalPage = institutionalPage;
    }

    @Generated
    public void setInstitutionalPageId(UUID institutionalPageId) {
        this.institutionalPageId = institutionalPageId;
    }

    @Generated
    public void setTitle(String title) {
        this.title = title;
    }

    @Generated
    public void setContent(String content) {
        this.content = content;
    }

    @Generated
    public void setImageUrl(String imageUrl) {
        this.imageUrl = imageUrl;
    }

    @Generated
    public void setResourceUrl(String resourceUrl) {
        this.resourceUrl = resourceUrl;
    }

    @Generated
    public void setLabels(List<String> labels) {
        this.labels = labels;
    }

    @Generated
    public void setCreationTime(Instant creationTime) {
        this.creationTime = creationTime;
    }

    @Generated
    public void setUpdateTime(Instant updateTime) {
        this.updateTime = updateTime;
    }

    @Generated
    public void setVersion(long version) {
        this.version = version;
    }

    @Generated
    public String toString() {
        return "ParagraphEntity(institutionalPage=" + String.valueOf(this.getInstitutionalPage()) + ", institutionalPageId=" + String.valueOf(this.getInstitutionalPageId()) + ", title=" + this.getTitle() + ", content=" + this.getContent() + ", imageUrl=" + this.getImageUrl() + ", resourceUrl=" + this.getResourceUrl() + ", labels=" + String.valueOf(this.getLabels()) + ", creationTime=" + String.valueOf(this.getCreationTime()) + ", updateTime=" + String.valueOf(this.getUpdateTime()) + ", version=" + this.getVersion() + ")";
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ParagraphEntity)) {
            return false;
        }
        ParagraphEntity other = (ParagraphEntity)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        if (this.getVersion() != other.getVersion()) {
            return false;
        }
        InstitutionalPageEntity this$institutionalPage = this.getInstitutionalPage();
        InstitutionalPageEntity other$institutionalPage = other.getInstitutionalPage();
        if (this$institutionalPage == null ? other$institutionalPage != null : !this$institutionalPage.equals(other$institutionalPage)) {
            return false;
        }
        UUID this$institutionalPageId = this.getInstitutionalPageId();
        UUID other$institutionalPageId = other.getInstitutionalPageId();
        if (this$institutionalPageId == null ? other$institutionalPageId != null : !((Object)this$institutionalPageId).equals(other$institutionalPageId)) {
            return false;
        }
        String this$title = this.getTitle();
        String other$title = other.getTitle();
        if (this$title == null ? other$title != null : !this$title.equals(other$title)) {
            return false;
        }
        String this$content = this.getContent();
        String other$content = other.getContent();
        if (this$content == null ? other$content != null : !this$content.equals(other$content)) {
            return false;
        }
        String this$imageUrl = this.getImageUrl();
        String other$imageUrl = other.getImageUrl();
        if (this$imageUrl == null ? other$imageUrl != null : !this$imageUrl.equals(other$imageUrl)) {
            return false;
        }
        String this$resourceUrl = this.getResourceUrl();
        String other$resourceUrl = other.getResourceUrl();
        if (this$resourceUrl == null ? other$resourceUrl != null : !this$resourceUrl.equals(other$resourceUrl)) {
            return false;
        }
        List this$labels = this.getLabels();
        List other$labels = other.getLabels();
        if (this$labels == null ? other$labels != null : !((Object)this$labels).equals(other$labels)) {
            return false;
        }
        Instant this$creationTime = this.getCreationTime();
        Instant other$creationTime = other.getCreationTime();
        if (this$creationTime == null ? other$creationTime != null : !((Object)this$creationTime).equals(other$creationTime)) {
            return false;
        }
        Instant this$updateTime = this.getUpdateTime();
        Instant other$updateTime = other.getUpdateTime();
        return !(this$updateTime == null ? other$updateTime != null : !((Object)this$updateTime).equals(other$updateTime));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof ParagraphEntity;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        long $version = this.getVersion();
        result = result * 59 + (int)($version >>> 32 ^ $version);
        InstitutionalPageEntity $institutionalPage = this.getInstitutionalPage();
        result = result * 59 + ($institutionalPage == null ? 43 : $institutionalPage.hashCode());
        UUID $institutionalPageId = this.getInstitutionalPageId();
        result = result * 59 + ($institutionalPageId == null ? 43 : ((Object)$institutionalPageId).hashCode());
        String $title = this.getTitle();
        result = result * 59 + ($title == null ? 43 : $title.hashCode());
        String $content = this.getContent();
        result = result * 59 + ($content == null ? 43 : $content.hashCode());
        String $imageUrl = this.getImageUrl();
        result = result * 59 + ($imageUrl == null ? 43 : $imageUrl.hashCode());
        String $resourceUrl = this.getResourceUrl();
        result = result * 59 + ($resourceUrl == null ? 43 : $resourceUrl.hashCode());
        List $labels = this.getLabels();
        result = result * 59 + ($labels == null ? 43 : ((Object)$labels).hashCode());
        Instant $creationTime = this.getCreationTime();
        result = result * 59 + ($creationTime == null ? 43 : ((Object)$creationTime).hashCode());
        Instant $updateTime = this.getUpdateTime();
        result = result * 59 + ($updateTime == null ? 43 : ((Object)$updateTime).hashCode());
        return result;
    }

    @Generated
    public ParagraphEntity() {
    }
}

