package com.finconsgroup.itserr.marketplace.institutionalpage.dm.controller;

import com.finconsgroup.itserr.marketplace.core.web.security.jwt.JwtTokenHolder;
import com.finconsgroup.itserr.marketplace.institutionalpage.dm.api.ModerationApi;
import com.finconsgroup.itserr.marketplace.institutionalpage.dm.dto.InputPatchIPModerationRequestDto;
import com.finconsgroup.itserr.marketplace.institutionalpage.dm.dto.InputSearchPendingInstitutionalPageDto;
import com.finconsgroup.itserr.marketplace.institutionalpage.dm.dto.OutputInstitutionalPageDto;
import com.finconsgroup.itserr.marketplace.institutionalpage.dm.dto.OutputModerationDto;
import com.finconsgroup.itserr.marketplace.institutionalpage.dm.service.InstitutionalPageService;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort.Direction;
import org.springframework.web.bind.annotation.RestController;

import java.util.Set;
import java.util.UUID;

/**
 * REST controller class for handling Moderation InstitutionalPage related API requests.
 *
 * <p>Implements the {@link ModerationApi} interface.</p>
 */
@Slf4j
@RequiredArgsConstructor
@RestController
public class ModerationController implements ModerationApi {

    private final InstitutionalPageService institutionalPageService;

    @Override
    public Page<OutputInstitutionalPageDto> findAllLatestVersionPendingInstitutionalPages(
            final Set<String> associationsToLoad,
            final int pageNumber,
            final int pageSize,
            final String sort,
            final Direction direction
    ) {
        log.debug("GET /api/v1/dm/institutional-page/institutional-pages/pending");
        UUID userId = JwtTokenHolder.getUserIdOrThrow();
        Pageable pageable = PageRequest.of(pageNumber, pageSize, direction, sort);
        return this.institutionalPageService.findAllLatestVersionPendingInstitutionalPages(userId, associationsToLoad, pageable);
    }

    @Override
    public Page<OutputInstitutionalPageDto> searchLatestVersionPendingInstitutionalPages(
            final InputSearchPendingInstitutionalPageDto inputSearchPendingInstitutionalPageDto,
            final Set<String> associationsToLoad,
            final int pageNumber,
            final int pageSize,
            final String sort,
            final Direction direction
    ) {
        log.debug("POST /api/v1/dm/institutional-page/institutional-pages/pending/search, inputSearchPendingInstitutionalPageDto: {}", inputSearchPendingInstitutionalPageDto);
        UUID userId = JwtTokenHolder.getUserIdOrThrow();
        Pageable pageable = PageRequest.of(pageNumber, pageSize, direction, sort);
        return institutionalPageService.searchLatestVersionPendingInstitutionalPages(
                userId,
                associationsToLoad,
                pageable,
                inputSearchPendingInstitutionalPageDto
        );
    }

    @Override
    public OutputInstitutionalPageDto findLatestVersionPendingInstitutionalPageById(final UUID institutionalPageId) {
        log.debug("GET /api/v1/dm/institutional-page/institutional-pages/pending/{}", institutionalPageId);
        UUID userId = JwtTokenHolder.getUserIdOrThrow();
        return this.institutionalPageService.findLatestVersionPendingInstitutionalPageById(userId, institutionalPageId);
    }

    @Override
    public OutputModerationDto acceptOrRejectPendingInstitutionalPage(
            final UUID institutionalPageId,
            final InputPatchIPModerationRequestDto inputPatchIPModerationRequestDto
    ) {
        log.debug("PATCH /api/v1/dm/institutional-page/institutional-pages/pending/{}, inputPatchIPModerationRequestDto: {}", institutionalPageId, inputPatchIPModerationRequestDto);
        UUID userId = JwtTokenHolder.getUserIdOrThrow();
        return this.institutionalPageService.acceptOrRejectPendingInstitutionalPage(userId, institutionalPageId, inputPatchIPModerationRequestDto);
    }

}
