/*
 * Decompiled with CFR 0.152.
 */
package com.finconsgroup.itserr.marketplace.institutionalpage.dm.api;

import com.finconsgroup.itserr.marketplace.institutionalpage.dm.dto.InputParagraphDto;
import com.finconsgroup.itserr.marketplace.institutionalpage.dm.dto.OutputInstitutionalPageDto;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.security.SecurityRequirement;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.validation.Valid;
import jakarta.validation.constraints.PositiveOrZero;
import java.util.UUID;
import org.springframework.http.HttpStatus;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseStatus;

@Tag(name="Paragraph", description="The Paragraph API: it provides endpoints for adding, updating and removing paragraphs.")
@SecurityRequirement(name="BearerAuth")
public interface ParagraphApi {
    @Operation(summary="Adds a new paragraph to the specified InstitutionalPage", responses={@ApiResponse(responseCode="200", description="OK"), @ApiResponse(responseCode="404", description="Not Found")})
    @PostMapping(value={"/institutional-page/institutional-pages/{institutionalPageId}/paragraphs"}, consumes={"application/json"}, produces={"application/json"})
    @ResponseStatus(value=HttpStatus.OK)
    public OutputInstitutionalPageDto addParagraph(@PathVariable(value="institutionalPageId") UUID var1, @RequestParam(name="position", required=false) @PositiveOrZero Integer var2, @Valid @RequestBody InputParagraphDto var3);

    @Operation(summary="Updates a paragraph in the specified InstitutionalPage", responses={@ApiResponse(responseCode="200", description="OK"), @ApiResponse(responseCode="404", description="Not Found")})
    @PutMapping(value={"/institutional-page/institutional-pages/{institutionalPageId}/paragraphs/{paragraphId}"}, consumes={"application/json"}, produces={"application/json"})
    @ResponseStatus(value=HttpStatus.OK)
    public OutputInstitutionalPageDto updateParagraph(@PathVariable(value="institutionalPageId") UUID var1, @PathVariable(value="paragraphId") UUID var2, @Valid @RequestBody InputParagraphDto var3);

    @Operation(summary="Removes a paragraph from the specified InstitutionalPage", responses={@ApiResponse(responseCode="200", description="OK"), @ApiResponse(responseCode="404", description="Not Found")})
    @DeleteMapping(value={"/institutional-page/institutional-pages/{institutionalPageId}/paragraphs/{paragraphId}"}, produces={"application/json"})
    @ResponseStatus(value=HttpStatus.OK)
    public OutputInstitutionalPageDto removeParagraph(@PathVariable(value="institutionalPageId") UUID var1, @PathVariable(value="paragraphId") UUID var2);
}

