/*
 * Decompiled with CFR 0.152.
 */
package com.finconsgroup.itserr.marketplace.institutional_page.bs.repository;

import com.finconsgroup.itserr.marketplace.institutional_page.bs.client.bs.UserProfileBsClient;
import com.finconsgroup.itserr.marketplace.institutional_page.bs.client.bs.dto.UserProfileBsDto;
import com.finconsgroup.itserr.marketplace.institutional_page.bs.client.dm.UserProfileDmClient;
import com.finconsgroup.itserr.marketplace.institutional_page.bs.client.dm.dto.UserProfileDmDto;
import com.finconsgroup.itserr.marketplace.institutional_page.bs.client.dm.dto.UserProfileIdsUserProfileDmDto;
import com.finconsgroup.itserr.marketplace.institutional_page.bs.client.dm.dto.UserProfilesUserProfileDmDto;
import com.finconsgroup.itserr.marketplace.institutional_page.bs.dto.OutputUserProfileDto;
import com.finconsgroup.itserr.marketplace.institutional_page.bs.exceptions.WP2UserProfileNotFoundException;
import com.finconsgroup.itserr.marketplace.institutional_page.bs.mapper.UserProfileMapper;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import lombok.Generated;
import org.springframework.stereotype.Component;

@Component
public class UserProfileRepository {
    private final UserProfileDmClient userProfileDmClient;
    private final UserProfileBsClient userProfileBsClient;
    private final UserProfileMapper userProfileMapper;

    public List<OutputUserProfileDto> getMemberProfilesOrThrow(List<UUID> memberIdsList) {
        if (memberIdsList == null || memberIdsList.isEmpty()) {
            return List.of();
        }
        HashSet<UUID> memberIds = new HashSet<UUID>(memberIdsList);
        UserProfilesUserProfileDmDto foundProfilesDto = this.userProfileDmClient.getProfilesByIds(new UserProfileIdsUserProfileDmDto(memberIds.stream().toList()), 0L, (long)memberIds.size());
        if (foundProfilesDto.getContent().size() != memberIds.size()) {
            Set foundProfileIds = foundProfilesDto.getContent().stream().map(UserProfileDmDto::getId).collect(Collectors.toSet());
            ArrayList notFoundProfileIds = new ArrayList();
            memberIds.forEach(profileId -> {
                if (!foundProfileIds.contains(profileId)) {
                    notFoundProfileIds.add(profileId);
                }
            });
            throw new WP2UserProfileNotFoundException(notFoundProfileIds);
        }
        ArrayList<OutputUserProfileDto> userProfiles = new ArrayList<OutputUserProfileDto>();
        foundProfilesDto.getContent().forEach(profile -> userProfiles.add(this.userProfileMapper.toOutputUserProfileDto(profile)));
        return userProfiles;
    }

    public UUID getAdmin() {
        return ((UserProfileBsDto)this.userProfileBsClient.getUserProfilesByRole("Catalogue-Editor").stream().findFirst().orElseThrow(() -> new WP2UserProfileNotFoundException("No admin user profile found."))).getId();
    }

    @Generated
    public UserProfileRepository(UserProfileDmClient userProfileDmClient, UserProfileBsClient userProfileBsClient, UserProfileMapper userProfileMapper) {
        this.userProfileDmClient = userProfileDmClient;
        this.userProfileBsClient = userProfileBsClient;
        this.userProfileMapper = userProfileMapper;
    }
}

