package com.finconsgroup.itserr.marketplace.institutional_page.bs.validation.validator;

import com.finconsgroup.itserr.marketplace.institutional_page.bs.dto.InputParagraphDto;
import com.finconsgroup.itserr.marketplace.institutional_page.bs.validation.ValidInputDto;
import jakarta.validation.ConstraintValidator;
import jakarta.validation.ConstraintValidatorContext;
import org.apache.commons.lang3.StringUtils;

public class InputParagraphDtoValidator implements ConstraintValidator<ValidInputDto, InputParagraphDto> {

    @Override
    public boolean isValid(InputParagraphDto value, ConstraintValidatorContext context) {
        if (value == null) {
            return true;
        }

        if (StringUtils.isAllBlank(value.getContent(), value.getImageUrl())) {
            context.disableDefaultConstraintViolation();
            context.buildConstraintViolationWithTemplate(
                    "At least one field between 'content' and 'imageUrl' must be provided"
            ).addConstraintViolation();
            return false;
        }

        return true;
    }


}
