package com.finconsgroup.itserr.marketplace.institutional_page.bs.client.dm.dto;

import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.time.Instant;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.UUID;

@Data
@Builder
@AllArgsConstructor
@NoArgsConstructor
public class InstitutionalPageIPDmDto {
    private UUID id;
    private String name;
    private UUID workspaceFolderId;
    private RelatedInstitutionalPageIPDmDto parentInstitutionalPage;
    private List<RelatedInstitutionalPageIPDmDto> childInstitutionalPages;
    private UUID rootInstitutionalPageId;
    private String rootInstitutionalPageName;
    private List<UUID> wpLeads;
    private List<UUID> members;
    private Boolean published;
    private Boolean toDelete;
    private Boolean hasUpdatedVersion;
    private String category;
    private String moderationStatus;
    private Instant publicationTime;
    private String rejectionMessage;
    private String abstractContent;
    private CopyrightIPDmDto copyright;
    private UUID maintainer;
    private List<ParagraphIPDmDto> paragraphs;
    private List<String> tags;
    private String imageUrl;
    private String userManualUrl;
    private String faqsUrl;
    private String applicationVersion;
    private String applicationType;
    private String license;
    private SupportedOsIPDmDto supportedOs;
    private RepositoriesIPDmDto repositories;
    private LinkedHashMap<String, String> additionalFields;
    private LinkedHashMap<String, String> externalLinks;
    private List<ButtonIPDmDto> buttons;
    private UUID updateLockedBy;
    private UUID lastModifiedBy;
    private Instant creationTime;
    private Instant updateTime;
}
