package com.finconsgroup.itserr.marketplace.favourite.user.bs.dto;

import io.swagger.v3.oas.annotations.media.Schema;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

/**
 * It represents the payload for response for Author.
 */
@Builder
@Schema(
    title = "Author Dto",
    description = "Represents the payload for response for Author"
)
@Data
@AllArgsConstructor
@NoArgsConstructor
public class AuthorDto {

    @Schema(
        description = "First Name",
        example = "John")
    private String firstName;

    @Schema(
        description = "Last Name",
        example = "Doe")
    private String lastName;

    @Schema(
        description = "Email",
        example = "john.doe@example.com")
    private String email;

    @Schema(
        description = "orcid",
        example = "00000-00000-00000-00000")
    private String orcid;
}
