package com.finconsgroup.itserr.marketplace.favourite.user.bs.dto.institutionalpage;

import com.fasterxml.jackson.annotation.JsonValue;
import lombok.Getter;

@Getter
public enum InstitutionalPageViewIPDmDto {
    ORIGINAL("Original"),
    LATEST("Latest"),
    APPROVED("Approved"),
    PENDING("Pending"),
    REJECTED("Rejected"),
    DRAFT("Draft");

    private final String label;

    InstitutionalPageViewIPDmDto(String label) {
        this.label = label;
    }

    @JsonValue
    public String getLabel() {
        return label;
    }

    /**
     * It maps the label to a {@link InstitutionalPageViewIPDmDto} object
     *
     * @param label the label to map to enum
     * @return {@link InstitutionalPageViewIPDmDto} instance if found
     * @throws IllegalArgumentException if no matching instance found
     */
    public static InstitutionalPageViewIPDmDto ofLabel(String label) {
        for (InstitutionalPageViewIPDmDto institutionalPageView : InstitutionalPageViewIPDmDto.values()) {
            if (institutionalPageView.label.equalsIgnoreCase(label)) {
                return institutionalPageView;
            }
        }

        throw new IllegalArgumentException("Unsupported value: " + label);
    }
}
