/*
 * Decompiled with CFR 0.152.
 */
package com.finconsgroup.itserr.marketplace.favourite.user.bs.service.impl;

import com.finconsgroup.itserr.marketplace.core.web.dto.OutputPageDto;
import com.finconsgroup.itserr.marketplace.core.web.enums.SortDirection;
import com.finconsgroup.itserr.marketplace.core.web.exception.WP2ResourceNotFoundException;
import com.finconsgroup.itserr.marketplace.favourite.user.bs.bean.DetailRequest;
import com.finconsgroup.itserr.marketplace.favourite.user.bs.client.InstitutionalPageBsClient;
import com.finconsgroup.itserr.marketplace.favourite.user.bs.config.FavouriteUserBsProperties;
import com.finconsgroup.itserr.marketplace.favourite.user.bs.dto.institutionalpage.InputSearchForMemberInstitutionalPageDto;
import com.finconsgroup.itserr.marketplace.favourite.user.bs.dto.institutionalpage.ModerationStatusInstitutionalPageDto;
import com.finconsgroup.itserr.marketplace.favourite.user.bs.dto.institutionalpage.OutputInstitutionalPageFavouriteDto;
import com.finconsgroup.itserr.marketplace.favourite.user.bs.enums.ItemContext;
import com.finconsgroup.itserr.marketplace.favourite.user.bs.service.FavouriteUserItemDetailProviderRegistry;
import com.finconsgroup.itserr.marketplace.favourite.user.bs.service.impl.AbstractFavouriteUserItemDetailProvider;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.lang.NonNull;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class FavouriteUserItemPageDetailProvider
extends AbstractFavouriteUserItemDetailProvider<OutputInstitutionalPageFavouriteDto> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(FavouriteUserItemPageDetailProvider.class);
    private final InstitutionalPageBsClient institutionalPageBsClient;

    public FavouriteUserItemPageDetailProvider(@NonNull FavouriteUserItemDetailProviderRegistry favouriteUserItemDetailProviderRegistry, @NonNull InstitutionalPageBsClient institutionalPageBsClient, @NonNull FavouriteUserBsProperties favouriteUserBsProperties) {
        super(favouriteUserItemDetailProviderRegistry, favouriteUserBsProperties, ItemContext.INSTITUTIONAL_PAGE);
        Objects.requireNonNull(institutionalPageBsClient, "pageDmClient must not be null");
        this.institutionalPageBsClient = institutionalPageBsClient;
    }

    @NonNull
    public OutputInstitutionalPageFavouriteDto getDetailById(@NonNull String itemId) {
        Objects.requireNonNull(itemId, "itemId must not be null");
        List<UUID> ids = List.of(UUID.fromString(itemId));
        OutputPageDto outputInstitutionalPageFavouritePageDto = this.institutionalPageBsClient.search(ModerationStatusInstitutionalPageDto.APPROVED, this.buildSearchRequest(ids), Set.of("wpLeads"), 0, 1, "id", SortDirection.ASC);
        if (CollectionUtils.isEmpty((Collection)outputInstitutionalPageFavouritePageDto.getContent())) {
            throw new WP2ResourceNotFoundException("Favourite institutional page not found");
        }
        return (OutputInstitutionalPageFavouriteDto)outputInstitutionalPageFavouritePageDto.getContent().getFirst();
    }

    @NonNull
    public OutputPageDto<OutputInstitutionalPageFavouriteDto> getDetails(@NonNull DetailRequest request) {
        if (request.getItemIds() == null || request.getItemIds().isEmpty()) {
            return OutputPageDto.emptyWithPageSize((int)request.getPageRequestDto().getPageSize());
        }
        List<UUID> ids = request.getItemIds().stream().map(UUID::fromString).toList();
        return this.institutionalPageBsClient.search(ModerationStatusInstitutionalPageDto.APPROVED, this.buildSearchRequest(ids), Set.of("wpLeads"), request.getPageRequestDto().getPageNumber(), request.getPageRequestDto().getPageSize(), request.getPageRequestDto().getSort(), request.getPageRequestDto().getDirection());
    }

    private InputSearchForMemberInstitutionalPageDto buildSearchRequest(List<UUID> ids) {
        return InputSearchForMemberInstitutionalPageDto.builder().ids(ids).includePrivateAndMember(Boolean.valueOf(true)).includePublishedAndMember(Boolean.valueOf(true)).includePublishedAndNotMember(Boolean.valueOf(true)).build();
    }
}

